/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.schema;

import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.xml.ls.SimpleLSResourceResolver;
import com.helger.commons.xml.sax.LoggingSAXErrorHandler;
import com.helger.commons.xml.schema.SchemaCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public class XMLSchemaCache
extends SchemaCache {
    private static boolean s_bDefaultInstantiated = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, XMLSchemaCache> s_aPerClassLoaderCache = new CommonsHashMap<String, XMLSchemaCache>();

    @Nonnull
    public static SchemaFactory createXSDSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public XMLSchemaCache() {
        this(new LoggingSAXErrorHandler(), new SimpleLSResourceResolver());
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler) {
        this(errorHandler, null);
    }

    public XMLSchemaCache(@Nullable LSResourceResolver lSResourceResolver) {
        this(null, lSResourceResolver);
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super("XSD", XMLSchemaCache.createXSDSchemaFactory(), errorHandler, lSResourceResolver);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static XMLSchemaCache getInstance() {
        XMLSchemaCache xMLSchemaCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return xMLSchemaCache;
    }

    @Nonnull
    public static XMLSchemaCache getInstanceOfClassLoader(@Nullable IHasClassLoader iHasClassLoader) {
        return XMLSchemaCache.getInstanceOfClassLoader(iHasClassLoader == null ? null : iHasClassLoader.getClassLoader());
    }

    @Nonnull
    public static XMLSchemaCache getInstanceOfClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return XMLSchemaCache.getInstance();
        }
        String string = classLoader.toString();
        XMLSchemaCache xMLSchemaCache = s_aRWLock.readLocked(() -> (XMLSchemaCache)s_aPerClassLoaderCache.get(string));
        if (xMLSchemaCache == null) {
            xMLSchemaCache = s_aRWLock.writeLocked(() -> {
                XMLSchemaCache xMLSchemaCache = (XMLSchemaCache)s_aPerClassLoaderCache.get(string);
                if (xMLSchemaCache == null) {
                    xMLSchemaCache = new XMLSchemaCache(new SimpleLSResourceResolver(classLoader));
                    s_aPerClassLoaderCache.put(string, xMLSchemaCache);
                }
                return xMLSchemaCache;
            });
        }
        return xMLSchemaCache;
    }

    public static void clearPerClassLoaderCache() {
        s_aRWLock.writeLocked(() -> s_aPerClassLoaderCache.clear());
    }

    private static final class SingletonHolder {
        private static final XMLSchemaCache s_aInstance = new XMLSchemaCache();

        private SingletonHolder() {
        }
    }
}

