/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.ext.CommonsEnumMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.xml.EXMLParserFeature;
import com.helger.commons.xml.EXMLParserProperty;
import com.helger.commons.xml.sax.LoggingSAXErrorHandler;
import com.helger.commons.xml.serialize.read.XMLLoggingExceptionCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.validation.Schema;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public final class DOMReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultNamespaceAware = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultValidating = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultIgnoringElementContentWhitespace = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultExpandEntityReferences = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultIgnoringComments = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultCoalescing = true;
    @GuardedBy(value="s_aRWLock")
    private static Schema s_aDefaultSchema;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultXIncludeAware;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserProperty, Object> s_aDefaultProperties;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserFeature, Boolean> s_aDefaultFeatures;
    @GuardedBy(value="s_aRWLock")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="s_aRWLock")
    private static ErrorHandler s_aDefaultErrorHandler;
    @GuardedBy(value="s_aRWLock")
    private static IExceptionCallback<Throwable> s_aDefaultExceptionHandler;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final DOMReaderDefaultSettings s_aInstance;

    private DOMReaderDefaultSettings() {
    }

    public static boolean isNamespaceAware() {
        return s_aRWLock.readLocked(() -> s_bDefaultNamespaceAware);
    }

    public static void setNamespaceAware(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultNamespaceAware = bl;
            return s_bDefaultNamespaceAware;
        });
    }

    public static boolean isValidating() {
        return s_aRWLock.readLocked(() -> s_bDefaultValidating);
    }

    public static void setValidating(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultValidating = bl;
            return s_bDefaultValidating;
        });
    }

    public static boolean isIgnoringElementContentWhitespace() {
        return s_aRWLock.readLocked(() -> s_bDefaultIgnoringElementContentWhitespace);
    }

    public static void setIgnoringElementContentWhitespace(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultIgnoringElementContentWhitespace = bl;
            return s_bDefaultIgnoringElementContentWhitespace;
        });
    }

    public static boolean isExpandEntityReferences() {
        return s_aRWLock.readLocked(() -> s_bDefaultExpandEntityReferences);
    }

    public static void setExpandEntityReferences(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultExpandEntityReferences = bl;
            return s_bDefaultExpandEntityReferences;
        });
    }

    public static boolean isIgnoringComments() {
        return s_aRWLock.readLocked(() -> s_bDefaultIgnoringComments);
    }

    public static void setIgnoringComments(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultIgnoringComments = bl;
            return s_bDefaultIgnoringComments;
        });
    }

    public static boolean isCoalescing() {
        return s_aRWLock.readLocked(() -> s_bDefaultCoalescing);
    }

    public static void setCoalescing(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultCoalescing = bl;
            return s_bDefaultCoalescing;
        });
    }

    @Nullable
    public static Schema getSchema() {
        return s_aRWLock.readLocked(() -> s_aDefaultSchema);
    }

    public static void setSchema(@Nullable Schema schema) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultSchema = schema;
            return s_aDefaultSchema;
        });
    }

    public static boolean isXIncludeAware() {
        return s_aRWLock.readLocked(() -> s_bDefaultXIncludeAware);
    }

    public static void setXIncludeAware(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultXIncludeAware = bl;
            return s_bDefaultXIncludeAware;
        });
    }

    public static boolean hasAnyProperties() {
        return s_aRWLock.readLocked(() -> !s_aDefaultProperties.isEmpty());
    }

    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        return s_aRWLock.readLocked(() -> s_aDefaultProperties.get(eXMLParserProperty));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return s_aRWLock.readLocked(() -> (ICommonsMap)s_aDefaultProperties.getClone());
    }

    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull(eXMLParserProperty, "Property");
        s_aRWLock.writeLocked(() -> {
            if (object != null) {
                s_aDefaultProperties.put(eXMLParserProperty, object);
            } else {
                s_aDefaultProperties.remove(eXMLParserProperty);
            }
        });
    }

    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            s_aRWLock.writeLocked(() -> s_aDefaultProperties.putAll(map));
        }
    }

    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(s_aRWLock.writeLocked(() -> s_aDefaultProperties.remove(eXMLParserProperty) != null));
    }

    @Nonnull
    public static EChange removeAllPropertyValues() {
        return s_aRWLock.writeLocked(() -> {
            if (s_aDefaultProperties.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aDefaultProperties.clear();
            return EChange.CHANGED;
        });
    }

    public static boolean hasAnyFeature() {
        return s_aRWLock.readLocked(() -> !s_aDefaultFeatures.isEmpty());
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        return s_aRWLock.readLocked(() -> (Boolean)s_aDefaultFeatures.get(eXMLParserFeature));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return s_aRWLock.readLocked(() -> (ICommonsMap)s_aDefaultFeatures.getClone());
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        s_aRWLock.writeLocked(() -> s_aDefaultFeatures.put(eXMLParserFeature, bl));
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        s_aRWLock.writeLocked(() -> {
            if (bl == null) {
                s_aDefaultFeatures.remove(eXMLParserFeature);
            } else {
                s_aDefaultFeatures.put(eXMLParserFeature, bl);
            }
        });
    }

    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            s_aRWLock.writeLocked(() -> s_aDefaultFeatures.putAll(map));
        }
    }

    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(s_aRWLock.writeLocked(() -> s_aDefaultFeatures.remove(eXMLParserFeature) != null));
    }

    @Nonnull
    public static EChange removeAllFeatures() {
        return s_aRWLock.writeLocked(() -> {
            if (s_aDefaultFeatures.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aDefaultFeatures.clear();
            return EChange.CHANGED;
        });
    }

    public static boolean requiresNewXMLParser() {
        return s_aRWLock.readLocked(() -> {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                return true;
            }
            if (!(s_bDefaultNamespaceAware && !s_bDefaultValidating && !s_bDefaultIgnoringElementContentWhitespace && s_bDefaultExpandEntityReferences && s_bDefaultIgnoringComments && s_bDefaultCoalescing && s_aDefaultSchema == null && !s_bDefaultXIncludeAware && s_aDefaultProperties.isEmpty() && s_aDefaultFeatures.isEmpty())) {
                return true;
            }
            return s_aDefaultEntityResolver != null;
        });
    }

    @Nullable
    public static EntityResolver getEntityResolver() {
        return s_aRWLock.readLocked(() -> s_aDefaultEntityResolver);
    }

    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultEntityResolver = entityResolver;
            return s_aDefaultEntityResolver;
        });
    }

    @Nullable
    public static ErrorHandler getErrorHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultErrorHandler);
    }

    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultErrorHandler = errorHandler;
            return s_aDefaultErrorHandler;
        });
    }

    @Nonnull
    public static IExceptionCallback<Throwable> getExceptionHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultExceptionHandler);
    }

    public static void setExceptionHandler(@Nonnull IExceptionCallback<Throwable> iExceptionCallback) {
        ValueEnforcer.notNull(iExceptionCallback, "ExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultExceptionHandler = iExceptionCallback;
            return s_aDefaultExceptionHandler;
        });
    }

    public static boolean isRequiresNewXMLParserExplicitly() {
        return s_aRWLock.readLocked(() -> s_bDefaultRequiresNewXMLParserExplicitly);
    }

    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
            return s_bDefaultRequiresNewXMLParserExplicitly;
        });
    }

    static {
        s_bDefaultXIncludeAware = false;
        s_aDefaultProperties = new CommonsEnumMap<EXMLParserProperty, Object>(EXMLParserProperty.class);
        s_aDefaultFeatures = new CommonsEnumMap<EXMLParserFeature, Boolean>(EXMLParserFeature.class);
        s_aDefaultErrorHandler = new LoggingSAXErrorHandler();
        s_aDefaultExceptionHandler = new XMLLoggingExceptionCallback();
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        s_aInstance = new DOMReaderDefaultSettings();
    }
}

