/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.write;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.xml.serialize.write.EXMLCharMode;
import com.helger.commons.xml.serialize.write.EXMLSerializeVersion;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XMLCharHelper {
    private static final BitSet INVALID_NAME_START_CHAR_XML10 = new BitSet(65536);
    private static final BitSet INVALID_NAME_START_CHAR_XML11 = new BitSet(65536);
    private static final BitSet INVALID_NAME_CHAR_XML10 = new BitSet(65536);
    private static final BitSet INVALID_NAME_CHAR_XML11 = new BitSet(65536);
    private static final BitSet INVALID_VALUE_CHAR_XML10 = new BitSet(65536);
    private static final BitSet INVALID_TEXT_VALUE_CHAR_XML11 = new BitSet(65536);
    private static final BitSet INVALID_CDATA_VALUE_CHAR_XML11 = new BitSet(65536);
    private static final BitSet INVALID_ATTR_VALUE_CHAR_XML11 = new BitSet(65536);
    private static final BitSet INVALID_CHAR_HTML = new BitSet(65536);
    private static final XMLCharHelper s_aInstance;

    private XMLCharHelper() {
    }

    public static boolean isInvalidXMLNameStartChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, int n) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                return INVALID_NAME_START_CHAR_XML10.get(n);
            }
            case XML_11: {
                return INVALID_NAME_START_CHAR_XML11.get(n);
            }
            case HTML: {
                return INVALID_CHAR_HTML.get(n);
            }
        }
        throw new IllegalArgumentException("Unsupported XML version " + eXMLSerializeVersion + "!");
    }

    public static boolean isInvalidXMLNameChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, int n) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                return INVALID_NAME_CHAR_XML10.get(n);
            }
            case XML_11: {
                return INVALID_NAME_CHAR_XML11.get(n);
            }
            case HTML: {
                return INVALID_CHAR_HTML.get(n);
            }
        }
        throw new IllegalArgumentException("Unsupported XML version " + eXMLSerializeVersion + "!");
    }

    public static boolean containsInvalidXMLNameChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string != null && XMLCharHelper.containsInvalidXMLNameChar(eXMLSerializeVersion, string.toCharArray());
    }

    public static boolean containsInvalidXMLNameChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (cArray != null) {
            int n = 0;
            for (char c : cArray) {
                if (n == 0 ? XMLCharHelper.isInvalidXMLNameStartChar(eXMLSerializeVersion, c) : XMLCharHelper.isInvalidXMLNameChar(eXMLSerializeVersion, c)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLNameChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string == null ? null : XMLCharHelper.getAllInvalidXMLNameChars(eXMLSerializeVersion, string.toCharArray());
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Character> getAllInvalidXMLNameChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = new CommonsLinkedHashSet<Character>();
        int n = 0;
        for (char c : cArray) {
            if (n == 0) {
                if (XMLCharHelper.isInvalidXMLNameStartChar(eXMLSerializeVersion, c)) {
                    commonsLinkedHashSet.add(Character.valueOf(c));
                }
            } else if (XMLCharHelper.isInvalidXMLNameChar(eXMLSerializeVersion, c)) {
                commonsLinkedHashSet.add(Character.valueOf(c));
            }
            ++n;
        }
        return commonsLinkedHashSet;
    }

    public static boolean isInvalidXMLTextChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, int n) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                return INVALID_VALUE_CHAR_XML10.get(n);
            }
            case XML_11: {
                return INVALID_TEXT_VALUE_CHAR_XML11.get(n);
            }
            case HTML: {
                return INVALID_CHAR_HTML.get(n);
            }
        }
        throw new IllegalArgumentException("Unsupported XML version " + eXMLSerializeVersion + "!");
    }

    public static boolean containsInvalidXMLTextChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string != null && XMLCharHelper.containsInvalidXMLTextChar(eXMLSerializeVersion, string.toCharArray());
    }

    public static boolean containsInvalidXMLTextChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (cArray != null) {
            for (char c : cArray) {
                if (!XMLCharHelper.isInvalidXMLTextChar(eXMLSerializeVersion, c)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLTextChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string == null ? null : XMLCharHelper.getAllInvalidXMLTextChars(eXMLSerializeVersion, string.toCharArray());
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Character> getAllInvalidXMLTextChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = new CommonsLinkedHashSet<Character>();
        for (char c : cArray) {
            if (!XMLCharHelper.isInvalidXMLTextChar(eXMLSerializeVersion, c)) continue;
            commonsLinkedHashSet.add(Character.valueOf(c));
        }
        return commonsLinkedHashSet;
    }

    public static boolean isInvalidXMLCDATAChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, int n) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                return INVALID_VALUE_CHAR_XML10.get(n);
            }
            case XML_11: {
                return INVALID_CDATA_VALUE_CHAR_XML11.get(n);
            }
            case HTML: {
                return INVALID_CHAR_HTML.get(n);
            }
        }
        throw new IllegalArgumentException("Unsupported XML version " + eXMLSerializeVersion + "!");
    }

    public static boolean containsInvalidXMLCDATAChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string != null && XMLCharHelper.containsInvalidXMLCDATAChar(eXMLSerializeVersion, string.toCharArray());
    }

    public static boolean containsInvalidXMLCDATAChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (cArray != null) {
            for (char c : cArray) {
                if (!XMLCharHelper.isInvalidXMLCDATAChar(eXMLSerializeVersion, c)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLCDATAChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string == null ? null : XMLCharHelper.getAllInvalidXMLCDATAChars(eXMLSerializeVersion, string.toCharArray());
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Character> getAllInvalidXMLCDATAChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = new CommonsLinkedHashSet<Character>();
        for (char c : cArray) {
            if (!XMLCharHelper.isInvalidXMLCDATAChar(eXMLSerializeVersion, c)) continue;
            commonsLinkedHashSet.add(Character.valueOf(c));
        }
        return commonsLinkedHashSet;
    }

    public static boolean isInvalidXMLAttributeValueChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, int n) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                return INVALID_VALUE_CHAR_XML10.get(n);
            }
            case XML_11: {
                return INVALID_ATTR_VALUE_CHAR_XML11.get(n);
            }
            case HTML: {
                return INVALID_CHAR_HTML.get(n);
            }
        }
        throw new IllegalArgumentException("Unsupported XML version " + eXMLSerializeVersion + "!");
    }

    public static boolean containsInvalidXMLAttributeValueChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string != null && XMLCharHelper.containsInvalidXMLAttributeValueChar(eXMLSerializeVersion, string.toCharArray());
    }

    public static boolean containsInvalidXMLAttributeValueChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (cArray != null) {
            for (char c : cArray) {
                if (!XMLCharHelper.isInvalidXMLAttributeValueChar(eXMLSerializeVersion, c)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLAttributeValueChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable String string) {
        return string == null ? null : XMLCharHelper.getAllInvalidXMLAttributeValueChars(eXMLSerializeVersion, string.toCharArray());
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Character> getAllInvalidXMLAttributeValueChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = new CommonsLinkedHashSet<Character>();
        for (char c : cArray) {
            if (!XMLCharHelper.isInvalidXMLAttributeValueChar(eXMLSerializeVersion, c)) continue;
            commonsLinkedHashSet.add(Character.valueOf(c));
        }
        return commonsLinkedHashSet;
    }

    public static boolean containsInvalidXMLChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nullable String string) {
        return string != null && XMLCharHelper.containsInvalidXMLChar(eXMLSerializeVersion, eXMLCharMode, string.toCharArray());
    }

    public static boolean containsInvalidXMLChar(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nullable char[] cArray) {
        switch (eXMLCharMode) {
            case ELEMENT_NAME: 
            case ATTRIBUTE_NAME: {
                return XMLCharHelper.containsInvalidXMLNameChar(eXMLSerializeVersion, cArray);
            }
            case ATTRIBUTE_VALUE_DOUBLE_QUOTES: 
            case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                return XMLCharHelper.containsInvalidXMLAttributeValueChar(eXMLSerializeVersion, cArray);
            }
            case TEXT: {
                return XMLCharHelper.containsInvalidXMLTextChar(eXMLSerializeVersion, cArray);
            }
            case CDATA: {
                return XMLCharHelper.containsInvalidXMLCDATAChar(eXMLSerializeVersion, cArray);
            }
        }
        throw new IllegalArgumentException("Unsupported XML character mode " + eXMLCharMode + "!");
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nullable String string) {
        return string == null ? null : XMLCharHelper.getAllInvalidXMLChars(eXMLSerializeVersion, eXMLCharMode, string.toCharArray());
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsSet<Character> getAllInvalidXMLChars(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nullable char[] cArray) {
        switch (eXMLCharMode) {
            case ELEMENT_NAME: 
            case ATTRIBUTE_NAME: {
                return XMLCharHelper.getAllInvalidXMLNameChars(eXMLSerializeVersion, cArray);
            }
            case ATTRIBUTE_VALUE_DOUBLE_QUOTES: 
            case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                return XMLCharHelper.getAllInvalidXMLAttributeValueChars(eXMLSerializeVersion, cArray);
            }
            case TEXT: {
                return XMLCharHelper.getAllInvalidXMLTextChars(eXMLSerializeVersion, cArray);
            }
            case CDATA: {
                return XMLCharHelper.getAllInvalidXMLCDATAChars(eXMLSerializeVersion, cArray);
            }
        }
        throw new IllegalArgumentException("Unsupported XML character mode " + eXMLCharMode + "!");
    }

    static {
        for (int i = 0; i <= 65535; ++i) {
            INVALID_NAME_START_CHAR_XML10.set(i, i >= 0 && i <= 64 || i >= 91 && i <= 94 || i == 96 || i >= 123 && i <= 191 || i == 215 || i == 247 || i >= 306 && i <= 307 || i >= 319 && i <= 320 || i == 329 || i == 383 || i >= 452 && i <= 460 || i >= 497 && i <= 499 || i >= 502 && i <= 505 || i >= 536 && i <= 591 || i >= 681 && i <= 698 || i >= 706 && i <= 901 || i == 903 || i == 907 || i == 909 || i == 930 || i == 975 || i >= 983 && i <= 985 || i == 987 || i == 989 || i == 991 || i == 993 || i >= 1012 && i <= 1024 || i == 1037 || i == 1104 || i == 1117 || i >= 1154 && i <= 1167 || i >= 1221 && i <= 1222 || i >= 1225 && i <= 1226 || i >= 1229 && i <= 1231 || i >= 1260 && i <= 1261 || i >= 1270 && i <= 1271 || i >= 1274 && i <= 1328 || i >= 1367 && i <= 1368 || i >= 1370 && i <= 1376 || i >= 1415 && i <= 1487 || i >= 1515 && i <= 1519 || i >= 1523 && i <= 1568 || i >= 1595 && i <= 1600 || i >= 1611 && i <= 1648 || i >= 1720 && i <= 1721 || i == 1727 || i == 1743 || i == 1748 || i >= 1750 && i <= 1764 || i >= 1767 && i <= 2308 || i >= 2362 && i <= 2364 || i >= 2366 && i <= 2391 || i >= 2402 && i <= 2436 || i >= 2445 && i <= 2446 || i >= 2449 && i <= 2450 || i == 2473 || i == 2481 || i >= 2483 && i <= 2485 || i >= 2490 && i <= 2523 || i == 2526 || i >= 2530 && i <= 2543 || i >= 2546 && i <= 2564 || i >= 2571 && i <= 2574 || i >= 2577 && i <= 2578 || i == 2601 || i == 2609 || i == 2612 || i == 2615 || i >= 2618 && i <= 2648 || i == 2653 || i >= 2655 && i <= 2673 || i >= 2677 && i <= 2692 || i == 2700 || i == 2702 || i == 2706 || i == 2729 || i == 2737 || i == 2740 || i >= 2746 && i <= 2748 || i >= 2750 && i <= 2783 || i >= 2785 && i <= 2820 || i >= 2829 && i <= 2830 || i >= 2833 && i <= 2834 || i == 2857 || i == 2865 || i >= 2868 && i <= 2869 || i >= 2874 && i <= 2876 || i >= 2878 && i <= 2907 || i == 2910 || i >= 2914 && i <= 2948 || i >= 2955 && i <= 2957 || i == 2961 || i >= 2966 && i <= 2968 || i == 2971 || i == 2973 || i >= 2976 && i <= 2978 || i >= 2981 && i <= 2983 || i >= 2987 && i <= 2989 || i == 2998 || i >= 3002 && i <= 3076 || i == 3085 || i == 3089 || i == 3113 || i == 3124 || i >= 3130 && i <= 3167 || i >= 3170 && i <= 3204 || i == 3213 || i == 3217 || i == 3241 || i == 3252 || i >= 3258 && i <= 3293 || i == 3295 || i >= 3298 && i <= 3332 || i == 3341 || i == 3345 || i == 3369 || i >= 3386 && i <= 3423 || i >= 3426 && i <= 3584 || i == 3631 || i == 3633 || i >= 3636 && i <= 3647 || i >= 3654 && i <= 3712 || i == 3715 || i >= 3717 && i <= 3718 || i == 3721 || i >= 3723 && i <= 3724 || i >= 3726 && i <= 3731 || i == 3736 || i == 3744 || i == 3748 || i == 3750 || i >= 3752 && i <= 3753 || i == 3756 || i == 3759 || i == 3761 || i >= 3764 && i <= 3772 || i >= 3774 && i <= 3775 || i >= 3781 && i <= 3903 || i == 3912 || i >= 3946 && i <= 4255 || i >= 4294 && i <= 4303 || i >= 4343 && i <= 4351 || i == 4353 || i == 4356 || i == 4360 || i == 4362 || i == 4365 || i >= 4371 && i <= 4411 || i == 4413 || i == 4415 || i >= 4417 && i <= 4427 || i == 4429 || i == 4431 || i >= 4433 && i <= 4435 || i >= 4438 && i <= 4440 || i >= 4442 && i <= 4446 || i == 4450 || i == 4452 || i == 4454 || i == 4456 || i >= 4458 && i <= 4460 || i >= 4463 && i <= 4465 || i == 4468 || i >= 4470 && i <= 4509 || i >= 4511 && i <= 4519 || i >= 4521 && i <= 4522 || i >= 4524 && i <= 4525 || i >= 4528 && i <= 4534 || i == 4537 || i == 4539 || i >= 4547 && i <= 4586 || i >= 4588 && i <= 4591 || i >= 4593 && i <= 4600 || i >= 4602 && i <= 7679 || i >= 7836 && i <= 7839 || i >= 7930 && i <= 7935 || i >= 7958 && i <= 7959 || i >= 7966 && i <= 7967 || i >= 8006 && i <= 8007 || i >= 8014 && i <= 8015 || i == 8024 || i == 8026 || i == 8028 || i == 8030 || i >= 8062 && i <= 8063 || i == 8117 || i == 8125 || i >= 8127 && i <= 8129 || i == 8133 || i >= 8141 && i <= 8143 || i >= 8148 && i <= 8149 || i >= 8156 && i <= 8159 || i >= 8173 && i <= 8177 || i == 8181 || i >= 8189 && i <= 8485 || i >= 8487 && i <= 8489 || i >= 8492 && i <= 8493 || i >= 8495 && i <= 8575 || i >= 8579 && i <= 12294 || i >= 12296 && i <= 12320 || i >= 12330 && i <= 12352 || i >= 12437 && i <= 12448 || i >= 12539 && i <= 12548 || i >= 12589 && i <= 19967 || i >= 40870 && i <= 44031 || i >= 55204 && i <= 65535);
            INVALID_NAME_START_CHAR_XML11.set(i, i >= 0 && i <= 64 || i >= 91 && i <= 94 || i == 96 || i >= 123 && i <= 191 || i == 215 || i == 247 || i >= 768 && i <= 879 || i == 894 || i >= 8192 && i <= 8203 || i >= 8206 && i <= 8303 || i >= 8592 && i <= 11263 || i >= 12272 && i <= 12288 || i >= 55296 && i <= 63743 || i >= 64976 && i <= 65007 || i >= 65534 && i <= 65535);
            INVALID_NAME_CHAR_XML10.set(i, i >= 0 && i <= 44 || i == 47 || i >= 58 && i <= 64 || i >= 91 && i <= 94 || i == 96 || i >= 123 && i <= 182 || i >= 184 && i <= 191 || i == 215 || i == 247 || i >= 306 && i <= 307 || i >= 319 && i <= 320 || i == 329 || i == 383 || i >= 452 && i <= 460 || i >= 497 && i <= 499 || i >= 502 && i <= 505 || i >= 536 && i <= 591 || i >= 681 && i <= 698 || i >= 706 && i <= 719 || i >= 722 && i <= 767 || i >= 838 && i <= 863 || i >= 866 && i <= 901 || i == 907 || i == 909 || i == 930 || i == 975 || i >= 983 && i <= 985 || i == 987 || i == 989 || i == 991 || i == 993 || i >= 1012 && i <= 1024 || i == 1037 || i == 1104 || i == 1117 || i == 1154 || i >= 1159 && i <= 1167 || i >= 1221 && i <= 1222 || i >= 1225 && i <= 1226 || i >= 1229 && i <= 1231 || i >= 1260 && i <= 1261 || i >= 1270 && i <= 1271 || i >= 1274 && i <= 1328 || i >= 1367 && i <= 1368 || i >= 1370 && i <= 1376 || i >= 1415 && i <= 1424 || i == 1442 || i == 1466 || i == 1470 || i == 1472 || i == 1475 || i >= 1477 && i <= 1487 || i >= 1515 && i <= 1519 || i >= 1523 && i <= 1568 || i >= 1595 && i <= 1599 || i >= 1619 && i <= 1631 || i >= 1642 && i <= 1647 || i >= 1720 && i <= 1721 || i == 1727 || i == 1743 || i == 1748 || i == 1769 || i >= 1774 && i <= 1775 || i >= 1786 && i <= 2304 || i == 2308 || i >= 2362 && i <= 2363 || i >= 2382 && i <= 2384 || i >= 2389 && i <= 2391 || i >= 2404 && i <= 2405 || i >= 2416 && i <= 2432 || i == 2436 || i >= 2445 && i <= 2446 || i >= 2449 && i <= 2450 || i == 2473 || i == 2481 || i >= 2483 && i <= 2485 || i >= 2490 && i <= 2491 || i == 2493 || i >= 2501 && i <= 2502 || i >= 2505 && i <= 2506 || i >= 2510 && i <= 2518 || i >= 2520 && i <= 2523 || i == 2526 || i >= 2532 && i <= 2533 || i >= 2546 && i <= 2561 || i >= 2563 && i <= 2564 || i >= 2571 && i <= 2574 || i >= 2577 && i <= 2578 || i == 2601 || i == 2609 || i == 2612 || i == 2615 || i >= 2618 && i <= 2619 || i == 2621 || i >= 2627 && i <= 2630 || i >= 2633 && i <= 2634 || i >= 2638 && i <= 2648 || i == 2653 || i >= 2655 && i <= 2661 || i >= 2677 && i <= 2688 || i == 2692 || i == 2700 || i == 2702 || i == 2706 || i == 2729 || i == 2737 || i == 2740 || i >= 2746 && i <= 2747 || i == 2758 || i == 2762 || i >= 2766 && i <= 2783 || i >= 2785 && i <= 2789 || i >= 2800 && i <= 2816 || i == 2820 || i >= 2829 && i <= 2830 || i >= 2833 && i <= 2834 || i == 2857 || i == 2865 || i >= 2868 && i <= 2869 || i >= 2874 && i <= 2875 || i >= 2884 && i <= 2886 || i >= 2889 && i <= 2890 || i >= 2894 && i <= 2901 || i >= 2904 && i <= 2907 || i == 2910 || i >= 2914 && i <= 2917 || i >= 2928 && i <= 2945 || i == 2948 || i >= 2955 && i <= 2957 || i == 2961 || i >= 2966 && i <= 2968 || i == 2971 || i == 2973 || i >= 2976 && i <= 2978 || i >= 2981 && i <= 2983 || i >= 2987 && i <= 2989 || i == 2998 || i >= 3002 && i <= 3005 || i >= 3011 && i <= 3013 || i == 3017 || i >= 3022 && i <= 3030 || i >= 3032 && i <= 3046 || i >= 3056 && i <= 3072 || i == 3076 || i == 3085 || i == 3089 || i == 3113 || i == 3124 || i >= 3130 && i <= 3133 || i == 3141 || i == 3145 || i >= 3150 && i <= 3156 || i >= 3159 && i <= 3167 || i >= 3170 && i <= 3173 || i >= 3184 && i <= 3201 || i == 3204 || i == 3213 || i == 3217 || i == 3241 || i == 3252 || i >= 3258 && i <= 3261 || i == 3269 || i == 3273 || i >= 3278 && i <= 3284 || i >= 3287 && i <= 3293 || i == 3295 || i >= 3298 && i <= 3301 || i >= 3312 && i <= 3329 || i == 3332 || i == 3341 || i == 3345 || i == 3369 || i >= 3386 && i <= 3389 || i >= 3396 && i <= 3397 || i == 3401 || i >= 3406 && i <= 3414 || i >= 3416 && i <= 3423 || i >= 3426 && i <= 3429 || i >= 3440 && i <= 3584 || i == 3631 || i >= 3643 && i <= 3647 || i == 3663 || i >= 3674 && i <= 3712 || i == 3715 || i >= 3717 && i <= 3718 || i == 3721 || i >= 3723 && i <= 3724 || i >= 3726 && i <= 3731 || i == 3736 || i == 3744 || i == 3748 || i == 3750 || i >= 3752 && i <= 3753 || i == 3756 || i == 3759 || i == 3770 || i >= 3774 && i <= 3775 || i == 3781 || i == 3783 || i >= 3790 && i <= 3791 || i >= 3802 && i <= 3863 || i >= 3866 && i <= 3871 || i >= 3882 && i <= 3892 || i == 3894 || i == 3896 || i >= 3898 && i <= 3901 || i == 3912 || i >= 3946 && i <= 3952 || i == 3973 || i >= 3980 && i <= 3983 || i == 3990 || i == 3992 || i >= 4014 && i <= 4016 || i == 4024 || i >= 4026 && i <= 4255 || i >= 4294 && i <= 4303 || i >= 4343 && i <= 4351 || i == 4353 || i == 4356 || i == 4360 || i == 4362 || i == 4365 || i >= 4371 && i <= 4411 || i == 4413 || i == 4415 || i >= 4417 && i <= 4427 || i == 4429 || i == 4431 || i >= 4433 && i <= 4435 || i >= 4438 && i <= 4440 || i >= 4442 && i <= 4446 || i == 4450 || i == 4452 || i == 4454 || i == 4456 || i >= 4458 && i <= 4460 || i >= 4463 && i <= 4465 || i == 4468 || i >= 4470 && i <= 4509 || i >= 4511 && i <= 4519 || i >= 4521 && i <= 4522 || i >= 4524 && i <= 4525 || i >= 4528 && i <= 4534 || i == 4537 || i == 4539 || i >= 4547 && i <= 4586 || i >= 4588 && i <= 4591 || i >= 4593 && i <= 4600 || i >= 4602 && i <= 7679 || i >= 7836 && i <= 7839 || i >= 7930 && i <= 7935 || i >= 7958 && i <= 7959 || i >= 7966 && i <= 7967 || i >= 8006 && i <= 8007 || i >= 8014 && i <= 8015 || i == 8024 || i == 8026 || i == 8028 || i == 8030 || i >= 8062 && i <= 8063 || i == 8117 || i == 8125 || i >= 8127 && i <= 8129 || i == 8133 || i >= 8141 && i <= 8143 || i >= 8148 && i <= 8149 || i >= 8156 && i <= 8159 || i >= 8173 && i <= 8177 || i == 8181 || i >= 8189 && i <= 8399 || i >= 8413 && i <= 8416 || i >= 8418 && i <= 8485 || i >= 8487 && i <= 8489 || i >= 8492 && i <= 8493 || i >= 8495 && i <= 8575 || i >= 8579 && i <= 12292 || i == 12294 || i >= 12296 && i <= 12320 || i == 12336 || i >= 12342 && i <= 12352 || i >= 12437 && i <= 12440 || i >= 12443 && i <= 12444 || i >= 12447 && i <= 12448 || i == 12539 || i >= 12543 && i <= 12548 || i >= 12589 && i <= 19967 || i >= 40870 && i <= 44031 || i >= 55204 && i <= 65535);
            INVALID_NAME_CHAR_XML11.set(i, i >= 0 && i <= 44 || i == 47 || i >= 58 && i <= 64 || i >= 91 && i <= 94 || i == 96 || i >= 123 && i <= 182 || i >= 184 && i <= 191 || i == 215 || i == 247 || i == 894 || i >= 8192 && i <= 8203 || i >= 8206 && i <= 8254 || i >= 8257 && i <= 8303 || i >= 8592 && i <= 11263 || i >= 12272 && i <= 12288 || i >= 55296 && i <= 63743 || i >= 64976 && i <= 65007 || i >= 65534 && i <= 65535);
            INVALID_VALUE_CHAR_XML10.set(i, i >= 0 && i <= 8 || i >= 11 && i <= 12 || i >= 14 && i <= 31 || i >= 55296 && i <= 57343 || i >= 65534 && i <= 65535);
            INVALID_TEXT_VALUE_CHAR_XML11.set(i, i == 0 || i >= 55296 && i <= 57343 || i >= 65534 && i <= 65535);
            INVALID_CDATA_VALUE_CHAR_XML11.set(i, i >= 0 && i <= 8 || i >= 11 && i <= 12 || i >= 14 && i <= 31 || i >= 127 && i <= 159 || i >= 55296 && i <= 57343 || i >= 65534 && i <= 65535);
            INVALID_ATTR_VALUE_CHAR_XML11.set(i, i == 0 || i >= 127 && i <= 132 || i >= 134 && i <= 159 || i >= 55296 && i <= 57343 || i >= 65534 && i <= 65535);
            INVALID_CHAR_HTML.set(i, i >= 0 && i <= 8 || i >= 11 && i <= 12 || i >= 14 && i <= 31 || i == 127 || i >= 55296 && i <= 57343 || i >= 65534 && i <= 65535);
        }
        s_aInstance = new XMLCharHelper();
    }
}

