/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.microdom.IMicroDocumentType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.serialize.write.EXMLCharMode;
import com.helger.commons.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.commons.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.commons.xml.serialize.write.EXMLSerializeVersion;
import com.helger.commons.xml.serialize.write.IXMLWriterSettings;
import com.helger.commons.xml.serialize.write.XMLMaskHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;

@NotThreadSafe
public class XMLEmitter {
    public static final boolean DEFAULT_THROW_EXCEPTION_ON_NESTED_COMMENTS = true;
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String COMMENT_START = "<!--";
    public static final String COMMENT_END = "-->";
    public static final char ER_START = '&';
    public static final char ER_END = ';';
    public static final String PI_START = "<?";
    public static final String PI_END = "?>";
    private static boolean s_bThrowExceptionOnNestedComments = true;
    private final Writer m_aWriter;
    private final IXMLWriterSettings m_aSettings;
    private EXMLSerializeVersion m_eXMLVersion;
    private final char m_cAttrValueBoundary;
    private final EXMLCharMode m_eAttrValueCharMode;

    public XMLEmitter(@Nonnull @WillNotClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aWriter = ValueEnforcer.notNull(writer, "Writer");
        this.m_aSettings = ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        this.m_eXMLVersion = iXMLWriterSettings.getSerializeVersion();
        this.m_cAttrValueBoundary = (char)(iXMLWriterSettings.isUseDoubleQuotesForAttributes() ? 34 : 39);
        this.m_eAttrValueCharMode = iXMLWriterSettings.isUseDoubleQuotesForAttributes() ? EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES : EXMLCharMode.ATTRIBUTE_VALUE_SINGLE_QUOTES;
    }

    public static void setThrowExceptionOnNestedComments(boolean bl) {
        s_bThrowExceptionOnNestedComments = bl;
    }

    public static boolean isThrowExceptionOnNestedComments() {
        return s_bThrowExceptionOnNestedComments;
    }

    @Nonnull
    private XMLEmitter _append(@Nonnull String string) {
        try {
            this.m_aWriter.write(string);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append string '" + string + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _append(char c) {
        try {
            this.m_aWriter.write(c);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append character '" + c + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _appendMasked(@Nonnull EXMLCharMode eXMLCharMode, @Nullable String string) {
        try {
            XMLMaskHelper.maskXMLTextTo(this.m_eXMLVersion, eXMLCharMode, this.m_aSettings.getIncorrectCharacterHandling(), string, this.m_aWriter);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append masked string '" + string + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _appendAttrValue(@Nullable String string) {
        return this._append(this.m_cAttrValueBoundary)._appendMasked(this.m_eAttrValueCharMode, string)._append(this.m_cAttrValueBoundary);
    }

    public void onXMLDeclaration(@Nullable EXMLVersion eXMLVersion, @Nullable String string, boolean bl) {
        if (eXMLVersion != null) {
            this.m_eXMLVersion = EXMLSerializeVersion.getFromXMLVersionOrThrow(eXMLVersion);
        }
        this._append(PI_START)._append("xml version=")._appendAttrValue(this.m_eXMLVersion.getXMLVersionString());
        if (StringHelper.hasText(string)) {
            this._append(" encoding=")._appendAttrValue(string);
        }
        if (bl) {
            this._append(" standalone=")._appendAttrValue("yes");
        }
        this._append(PI_END);
        if (this.m_aSettings.getIndent().isAlign()) {
            this._append(this.m_aSettings.getNewLineString());
        }
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull IMicroDocumentType iMicroDocumentType) {
        return XMLEmitter.getDocTypeHTMLRepresentation(eXMLSerializeVersion, eXMLIncorrectCharacterHandling, iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("<!DOCTYPE ").append(string);
        if (string2 != null && string3 != null) {
            stringBuilder.append(" PUBLIC \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string2)).append("\" \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string3)).append('\"');
        } else if (string3 != null) {
            stringBuilder.append(" SYSTEM \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string3)).append('\"');
        }
        return stringBuilder.append('>').toString();
    }

    public void onDocumentType(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull(string, "QualifiedElementName");
        String string4 = XMLEmitter.getDocTypeHTMLRepresentation(this.m_eXMLVersion, this.m_aSettings.getIncorrectCharacterHandling(), string, string2, string3);
        this._append(string4);
        if (this.m_aSettings.getIndent().isAlign()) {
            this._append(this.m_aSettings.getNewLineString());
        }
    }

    public void onProcessingInstruction(@Nonnull String string, @Nullable String string2) {
        this._append(PI_START)._append(string);
        if (StringHelper.hasText(string2)) {
            this._append(' ')._append(string2);
        }
        this._append(PI_END);
        if (this.m_aSettings.getIndent().isAlign()) {
            this._append(this.m_aSettings.getNewLineString());
        }
    }

    public void onEntityReference(@Nonnull String string) {
        this._append('&')._append(string)._append(';');
    }

    public void onContentElementWhitespace(@Nullable CharSequence charSequence) {
        if (StringHelper.hasText(charSequence)) {
            this._append(charSequence.toString());
        }
    }

    public void onComment(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            if (XMLEmitter.isThrowExceptionOnNestedComments() && (string.contains(COMMENT_START) || string.contains(COMMENT_END))) {
                throw new IllegalArgumentException("XML comment contains nested XML comment: " + string);
            }
            this._append(COMMENT_START)._append(string)._append(COMMENT_END);
        }
    }

    public void onText(@Nullable String string, boolean bl) {
        if (bl) {
            this._appendMasked(EXMLCharMode.TEXT, string);
        } else {
            this._append(string);
        }
    }

    public void onCDATA(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            if (string.indexOf(CDATA_END) >= 0) {
                ICommonsList<String> iCommonsList = StringHelper.getExploded(CDATA_END, string);
                int n = iCommonsList.size();
                for (int i = 0; i < n; ++i) {
                    this._append(CDATA_START);
                    if (i > 0) {
                        this._append('>');
                    }
                    this._appendMasked(EXMLCharMode.CDATA, (String)iCommonsList.get(i));
                    if (i < n - 1) {
                        this._append("]]");
                    }
                    this._append(CDATA_END);
                }
            } else {
                this._append(CDATA_START)._appendMasked(EXMLCharMode.CDATA, string)._append(CDATA_END);
            }
        }
    }

    public void onElementStart(@Nullable String string, @Nonnull String string2, @Nullable Map<QName, String> map, boolean bl, @Nonnull EXMLSerializeBracketMode eXMLSerializeBracketMode) {
        this._append('<');
        if (StringHelper.hasText(string)) {
            this._appendMasked(EXMLCharMode.ELEMENT_NAME, string)._append(':');
        }
        this._appendMasked(EXMLCharMode.ELEMENT_NAME, string2);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<QName, String> entry : map.entrySet()) {
                QName qName = entry.getKey();
                String string3 = qName.getPrefix();
                String string4 = qName.getLocalPart();
                String string5 = entry.getValue();
                this._append(' ');
                if (StringHelper.hasText(string3)) {
                    this._append(string3)._append(':');
                }
                this._appendMasked(EXMLCharMode.ATTRIBUTE_NAME, string4)._append('=')._appendAttrValue(string5);
            }
        }
        if (eXMLSerializeBracketMode.isSelfClosed()) {
            this._append(this.m_aSettings.isSpaceOnSelfClosedElement() ? " />" : "/>");
        } else {
            this._append('>');
        }
    }

    public void onElementEnd(@Nullable String string, @Nonnull String string2, boolean bl, @Nonnull EXMLSerializeBracketMode eXMLSerializeBracketMode) {
        if (eXMLSerializeBracketMode.isOpenClose()) {
            this._append("</");
            if (StringHelper.hasText(string)) {
                this._appendMasked(EXMLCharMode.ELEMENT_NAME, string)._append(':');
            }
            this._appendMasked(EXMLCharMode.ELEMENT_NAME, string2)._append('>');
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("writer", this.m_aWriter).append("settings", this.m_aSettings).append("version", this.m_eXMLVersion).append("attrValueBoundary", this.m_cAttrValueBoundary).append("attrValueCharMode", this.m_eAttrValueCharMode).toString();
    }
}

