/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.transform;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IHasResourceErrorGroup;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.transform.AbstractTransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;

@ThreadSafe
public class CollectingTransformErrorListener
extends AbstractTransformErrorListener
implements IHasResourceErrorGroup {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingTransformErrorListener() {
    }

    public CollectingTransformErrorListener(@Nullable ErrorListener errorListener) {
        super(errorListener);
    }

    @Override
    protected void internalLog(@Nonnull IResourceError iResourceError) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.addResourceError(iResourceError));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.getClone());
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aRWLock.writeLocked(() -> this.m_aErrors.clear());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("errors", this.m_aErrors).toString();
    }
}

