/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMessageDigestAlgorithm {
    MD5("MD5"),
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_384("SHA-384"),
    SHA_512("SHA-512");

    private final String m_sAlgorithm;

    private EMessageDigestAlgorithm(String string2) {
        this.m_sAlgorithm = string2;
    }

    @Nonnull
    @Nonempty
    public String getAlgorithm() {
        return this.m_sAlgorithm;
    }

    @Nonnull
    public MessageDigest createMessageDigest() {
        return this.createMessageDigest(null);
    }

    @Nonnull
    public MessageDigest createMessageDigest(@Nullable Provider provider) {
        try {
            if (provider == null) {
                return MessageDigest.getInstance(this.m_sAlgorithm);
            }
            return MessageDigest.getInstance(this.m_sAlgorithm, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Failed to resolve MessageDigest algorithm '" + this.m_sAlgorithm + "'", noSuchAlgorithmException);
        }
    }

    @Nullable
    public static EMessageDigestAlgorithm getFromStringIgnoreCase(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EMessageDigestAlgorithm.class, eMessageDigestAlgorithm -> eMessageDigestAlgorithm.m_sAlgorithm.equalsIgnoreCase(string));
    }
}

