/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.charset.CCharset;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.iterate.FileSystemIterator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import java.io.File;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPITestHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SPITestHelper.class);

    private SPITestHelper() {
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid(@Nonnull String string, boolean bl) throws Exception {
        int n = 0;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string)) {
                Object object;
                block18: {
                    if (!file2.isFile()) continue;
                    s_aLogger.info("Checking SPI file " + file2.getAbsolutePath());
                    try {
                        Class.forName(file2.getName());
                    }
                    catch (Throwable throwable) {
                        object = "No interface representing " + file2.getName() + " exists: " + ClassHelper.getClassLocalName(throwable) + " - " + throwable.getMessage();
                        s_aLogger.warn((String)object);
                        if (bl) break block18;
                        throw new Exception((String)object);
                    }
                }
                try {
                    NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), CCharset.CHARSET_SERVICE_LOADER_OBJ));
                    object = null;
                    try {
                        String string2;
                        int n2 = 0;
                        while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                            String string3 = StringHelper.trim(string2);
                            if (!StringHelper.hasText(string3)) continue;
                            Class.forName(string2);
                            ++n2;
                            ++n;
                        }
                        if (n2 == 0) {
                            s_aLogger.warn("  Contains no single valid implementation!");
                            continue;
                        }
                        s_aLogger.info("  All implementations (" + n2 + ") are valid!");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (nonBlockingBufferedReader == null) continue;
                        if (object != null) {
                            try {
                                nonBlockingBufferedReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        nonBlockingBufferedReader.close();
                    }
                }
                catch (Throwable throwable) {
                    s_aLogger.warn("  Error checking content: " + throwable.getMessage());
                    if (bl) continue;
                    throw new Exception("Error checking SPI file " + file2.getAbsolutePath(), throwable);
                }
            }
        }
        return n;
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid(boolean bl) throws Exception {
        int n = 0;
        n += SPITestHelper.testIfAllSPIImplementationsAreValid("src/main/resources/META-INF/services", bl);
        return n += SPITestHelper.testIfAllSPIImplementationsAreValid("src/test/resources/META-INF/services", bl);
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid() throws Exception {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(false);
    }
}

