/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.traits;

import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.typeconvert.TypeConverterException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IConvertibleByIndexTrait {
    @Nullable
    public Object getValue(@Nonnegative int var1);

    @Nullable
    default public Class<?> getValueClass(@Nonnegative int n) {
        Object object = this.getValue(n);
        return object == null ? null : object.getClass();
    }

    default public boolean hasValue(@Nonnegative int n) {
        return this.getValue(n) != null;
    }

    default public boolean hasNoValue(@Nonnegative int n) {
        return this.getValue(n) == null;
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n) throws ClassCastException {
        return (T)GenericReflection.uncheckedCast(this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t) throws ClassCastException {
        Object object = this.getValue(n);
        return (T)(object == null ? t : GenericReflection.uncheckedCast(object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nonnull Class<T> clazz) throws ClassCastException {
        return clazz.cast(this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) throws ClassCastException {
        Object object = this.getValue(n);
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return TypeConverter.convertIfNecessary(this.getValue(n), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(n);
        return object == null ? t : TypeConverter.convertIfNecessary(object, clazz);
    }

    default public boolean getAsBoolean(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToBoolean(this.getValue(n));
    }

    default public boolean getAsBoolean(@Nonnegative int n, boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(n), bl);
    }

    default public byte getAsByte(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToByte(this.getValue(n));
    }

    default public byte getAsByte(@Nonnegative int n, byte by) {
        return TypeConverter.convertToByte(this.getValue(n), by);
    }

    default public char getAsChar(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToChar(this.getValue(n));
    }

    default public char getAsChar(@Nonnegative int n, char c) {
        return TypeConverter.convertToChar(this.getValue(n), c);
    }

    default public double getAsDouble(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToDouble(this.getValue(n));
    }

    default public double getAsDouble(@Nonnegative int n, double d) {
        return TypeConverter.convertToDouble(this.getValue(n), d);
    }

    default public float getAsFloat(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToFloat(this.getValue(n));
    }

    default public float getAsFloat(@Nonnegative int n, float f) {
        return TypeConverter.convertToFloat(this.getValue(n), f);
    }

    default public int getAsInt(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToInt(this.getValue(n));
    }

    default public int getAsInt(@Nonnegative int n, int n2) {
        return TypeConverter.convertToInt(this.getValue(n), n2);
    }

    default public long getAsLong(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToLong(this.getValue(n));
    }

    default public long getAsLong(@Nonnegative int n, long l) {
        return TypeConverter.convertToLong(this.getValue(n), l);
    }

    default public short getAsShort(@Nonnegative int n) throws TypeConverterException {
        return TypeConverter.convertToShort(this.getValue(n));
    }

    default public short getAsShort(@Nonnegative int n, short s) {
        return TypeConverter.convertToShort(this.getValue(n), s);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, String.class);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n, @Nullable String string) throws TypeConverterException {
        return this.getConvertedValue(n, string, String.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n, @Nullable BigDecimal bigDecimal) throws TypeConverterException {
        return this.getConvertedValue(n, bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n, @Nullable BigInteger bigInteger) throws TypeConverterException {
        return this.getConvertedValue(n, bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n, @Nullable LocalDate localDate) throws TypeConverterException {
        return this.getConvertedValue(n, localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n, @Nullable LocalTime localTime) throws TypeConverterException {
        return this.getConvertedValue(n, localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n, @Nullable LocalDateTime localDateTime) throws TypeConverterException {
        return this.getConvertedValue(n, localDateTime, LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Byte.class);
    }

    @Nullable
    default public Character getAsCharObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Double.class);
    }

    @Nullable
    default public Float getAsFloatObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Float.class);
    }

    @Nullable
    default public Integer getAsIntObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Integer.class);
    }

    @Nullable
    default public Long getAsLongObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Long.class);
    }

    @Nullable
    default public Short getAsShortObj(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp(@Nonnegative int n) throws TypeConverterException {
        return this.getConvertedValue(n, Timestamp.class);
    }
}

