/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.math.MathHelper;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class Base32Codec
implements IByteArrayCodec {
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final byte[] HEX_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
    private static final byte[] HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
    private static final int MASK_5BITS = 31;
    private static final byte DEFAULT_PAD = 61;
    private byte m_nPad = (byte)61;
    private boolean m_bAddPadding = true;
    private byte[] m_aEncodeTable;
    private byte[] m_aDecodeTable;

    public Base32Codec() {
        this(false);
    }

    public Base32Codec(boolean bl) {
        if (bl) {
            this.m_aEncodeTable = HEX_ENCODE_TABLE;
            this.m_aDecodeTable = HEX_DECODE_TABLE;
        } else {
            this.m_aEncodeTable = ENCODE_TABLE;
            this.m_aDecodeTable = DECODE_TABLE;
        }
    }

    public boolean isHexEncoding() {
        return this.m_aEncodeTable == HEX_ENCODE_TABLE;
    }

    public byte getPad() {
        return this.m_nPad;
    }

    private boolean _isInAlphabet(byte by) {
        return by >= 0 && by < this.m_aDecodeTable.length && this.m_aDecodeTable[by] != -1;
    }

    private static boolean _isWhiteSpace(byte by) {
        return by == 32 || by == 10 || by == 13 || by == 9;
    }

    @Nonnull
    public Base32Codec setPad(byte by) {
        if (this._isInAlphabet(by) || Base32Codec._isWhiteSpace(by)) {
            throw new IllegalArgumentException("pad must not be in alphabet or whitespace");
        }
        this.m_nPad = by;
        return this;
    }

    public boolean isAddPadding() {
        return this.m_bAddPadding;
    }

    @Nonnull
    public Base32Codec setAddPaddding(boolean bl) {
        this.m_bAddPadding = bl;
        return this;
    }

    @Override
    public int getEncodedLength(int n) {
        return MathHelper.getRoundedUp(n * 8 / 5, 8);
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        byte by = this.m_nPad;
        byte[] byArray2 = this.m_aEncodeTable;
        int n3 = n2;
        int n4 = n;
        block8: while (n3 > 0) {
            try {
                switch (n3) {
                    case 1: {
                        int n5;
                        int n6 = byArray[n4] & 0xFF;
                        n4 += n3;
                        outputStream.write(byArray2[n6 >> 3 & 0x1F]);
                        outputStream.write(byArray2[n6 << 2 & 0x1F]);
                        if (this.m_bAddPadding) {
                            for (n5 = 0; n5 < 6; ++n5) {
                                outputStream.write(by);
                            }
                        }
                        n3 = 0;
                        continue block8;
                    }
                    case 2: {
                        int n5;
                        int n7 = (byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
                        n4 += n3;
                        outputStream.write(byArray2[n7 >> 11 & 0x1F]);
                        outputStream.write(byArray2[n7 >> 6 & 0x1F]);
                        outputStream.write(byArray2[n7 >> 1 & 0x1F]);
                        outputStream.write(byArray2[n7 << 4 & 0x1F]);
                        if (this.m_bAddPadding) {
                            for (n5 = 0; n5 < 4; ++n5) {
                                outputStream.write(by);
                            }
                        }
                        n3 = 0;
                        continue block8;
                    }
                    case 3: {
                        int n5;
                        int n8 = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
                        n4 += n3;
                        outputStream.write(byArray2[n8 >> 19 & 0x1F]);
                        outputStream.write(byArray2[n8 >> 14 & 0x1F]);
                        outputStream.write(byArray2[n8 >> 9 & 0x1F]);
                        outputStream.write(byArray2[n8 >> 4 & 0x1F]);
                        outputStream.write(byArray2[n8 << 1 & 0x1F]);
                        if (this.m_bAddPadding) {
                            for (n5 = 0; n5 < 3; ++n5) {
                                outputStream.write(by);
                            }
                        }
                        n3 = 0;
                        continue block8;
                    }
                    case 4: {
                        int n9 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                        n4 += n3;
                        outputStream.write(byArray2[n9 >> 27 & 0x1F]);
                        outputStream.write(byArray2[n9 >> 22 & 0x1F]);
                        outputStream.write(byArray2[n9 >> 17 & 0x1F]);
                        outputStream.write(byArray2[n9 >> 12 & 0x1F]);
                        outputStream.write(byArray2[n9 >> 7 & 0x1F]);
                        outputStream.write(byArray2[n9 >> 2 & 0x1F]);
                        outputStream.write(byArray2[n9 << 3 & 0x1F]);
                        if (this.m_bAddPadding) {
                            outputStream.write(by);
                        }
                        n3 = 0;
                        continue block8;
                    }
                }
                long l = (long)(byArray[n4] & 0xFF) << 32 | (long)(byArray[n4 + 1] & 0xFF) << 24 | (long)(byArray[n4 + 2] & 0xFF) << 16 | (long)(byArray[n4 + 3] & 0xFF) << 8 | (long)(byArray[n4 + 4] & 0xFF);
                n4 += 5;
                outputStream.write(byArray2[(int)(l >> 35) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 30) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 25) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 20) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 15) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 10) & 0x1F]);
                outputStream.write(byArray2[(int)(l >> 5) & 0x1F]);
                outputStream.write(byArray2[(int)l & 0x1F]);
                n3 -= 5;
            }
            catch (IOException iOException) {
                throw new EncodeException("Failed to encode Base32", iOException);
            }
        }
    }

    @Override
    public int getDecodedLength(int n) {
        return MathHelper.getRoundedUp(n, 8) * 5 / 8;
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        byte by = this.m_nPad;
        byte[] byArray2 = this.m_aDecodeTable;
        byte[] byArray3 = new byte[8];
        int n3 = n2;
        int n4 = n;
        while (n3 > 0) {
            int n5 = n3 > 8 ? 8 : n3;
            n3 -= n5;
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7;
                if ((n7 = byArray[n4++] & 0xFF) == by) {
                    n5 = i;
                    break;
                }
                int n8 = n6 = n7 < 0 || n7 >= byArray2.length ? -1 : byArray2[n7];
                if (n6 < 0) {
                    throw new DecodeException("Cannot Base32 decode char " + n7);
                }
                byArray3[i] = n6;
            }
            try {
                switch (n5) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        outputStream.write(byArray3[0] << 3 | byArray3[1] >> 2);
                        break;
                    }
                    case 4: {
                        outputStream.write(byArray3[0] << 3 | byArray3[1] >> 2);
                        outputStream.write(byArray3[1] << 6 | byArray3[2] << 1 | byArray3[3] >> 4);
                        break;
                    }
                    case 5: {
                        outputStream.write(byArray3[0] << 3 | byArray3[1] >> 2);
                        outputStream.write(byArray3[1] << 6 | byArray3[2] << 1 | byArray3[3] >> 4);
                        outputStream.write(byArray3[3] << 4 | byArray3[4] >> 1);
                        break;
                    }
                    case 7: {
                        outputStream.write(byArray3[0] << 3 | byArray3[1] >> 2);
                        outputStream.write(byArray3[1] << 6 | byArray3[2] << 1 | byArray3[3] >> 4);
                        outputStream.write(byArray3[3] << 4 | byArray3[4] >> 1);
                        outputStream.write(byArray3[4] << 7 | byArray3[5] << 2 | byArray3[6] >> 3);
                        break;
                    }
                    case 8: {
                        outputStream.write(byArray3[0] << 3 | byArray3[1] >> 2);
                        outputStream.write(byArray3[1] << 6 | byArray3[2] << 1 | byArray3[3] >> 4);
                        outputStream.write(byArray3[3] << 4 | byArray3[4] >> 1);
                        outputStream.write(byArray3[4] << 7 | byArray3[5] << 2 | byArray3[6] >> 3);
                        outputStream.write(byArray3[6] << 5 | byArray3[7]);
                        break;
                    }
                    default: {
                        throw new DecodeException("Unexpected number of Base32 bytes left: " + n5);
                    }
                }
            }
            catch (IOException iOException) {
                throw new DecodeException("Failed to decode Base32", iOException);
            }
        }
    }

    static {
        if (ENCODE_TABLE.length != 32) {
            throw new InitializationException("ENCODE_TABLE");
        }
        if (HEX_ENCODE_TABLE.length != 32) {
            throw new InitializationException("HEX_ENCODE_TABLE");
        }
    }
}

