/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.multimap;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.state.EChange;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMultiMap<KEYTYPE, VALUETYPE, COLLTYPE extends ICommonsCollection<VALUETYPE>>
extends ICommonsMap<KEYTYPE, COLLTYPE> {
    @Nonnull
    @ReturnsMutableObject(value="design")
    public COLLTYPE getOrCreate(@Nonnull KEYTYPE var1);

    @Nonnull
    default public EChange putSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return EChange.valueOf(this.getOrCreate(KEYTYPE).add(VALUETYPE));
    }

    @Nonnull
    default public EChange putAllIn(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
            eChange = eChange.or(this.putSingle(entry.getKey(), entry.getValue()));
        }
        return eChange;
    }

    @Nonnull
    default public EChange removeSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        ICommonsCollection iCommonsCollection = (ICommonsCollection)this.get(KEYTYPE);
        return iCommonsCollection == null ? EChange.UNCHANGED : EChange.valueOf(iCommonsCollection.remove(VALUETYPE));
    }

    default public boolean containsSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        ICommonsCollection iCommonsCollection = (ICommonsCollection)this.get(KEYTYPE);
        return iCommonsCollection != null && iCommonsCollection.contains(VALUETYPE);
    }

    @Nonnegative
    default public long getTotalValueCount() {
        long l = 0L;
        for (Collection collection : this.values()) {
            l += (long)collection.size();
        }
        return l;
    }

    default public void forEachSingle(@Nonnull BiConsumer<KEYTYPE, VALUETYPE> biConsumer) {
        for (Map.Entry entry : this.entrySet()) {
            for (Object e : (ICommonsCollection)entry.getValue()) {
                biConsumer.accept(entry.getKey(), e);
            }
        }
    }
}

