/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@DevelopersNote(value="The mutable m_aHashCode does not contradict thread safety")
public final class DateTimeFormatterPattern {
    private final String m_sPattern;
    private final ResolverStyle m_eResolverStyle;
    private final DateTimeFormatter m_aFormatter;
    private transient int m_nHashCode = 0;

    public DateTimeFormatterPattern(@Nonnull @Nonempty String string, @Nonnull ResolverStyle resolverStyle) throws IllegalArgumentException {
        ValueEnforcer.notEmpty(string, "RegEx");
        ValueEnforcer.notNull(resolverStyle, "ResolverStyle");
        this.m_sPattern = string;
        this.m_eResolverStyle = resolverStyle;
        this.m_aFormatter = new DateTimeFormatterBuilder().appendPattern(string).toFormatter().withResolverStyle(this.m_eResolverStyle);
    }

    @Nonnull
    @Nonempty
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public ResolverStyle getResolverStyle() {
        return this.m_eResolverStyle;
    }

    @Nonnull
    public DateTimeFormatter getAsFormatter() {
        return this.m_aFormatter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DateTimeFormatterPattern dateTimeFormatterPattern = (DateTimeFormatterPattern)object;
        return this.m_sPattern.equals(dateTimeFormatterPattern.m_sPattern) && this.m_eResolverStyle.equals((Object)dateTimeFormatterPattern.m_eResolverStyle);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPattern).append((Enum)this.m_eResolverStyle)).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Pattern", this.m_sPattern).append("ResolverStyle", this.m_eResolverStyle).toString();
    }
}

