/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeContent;
import com.helger.commons.state.EChange;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MimeTypeDeterminator {
    public static final IMimeType DEFAULT_MIME_TYPE = CMimeType.APPLICATION_OCTET_STREAM;
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeTypeDeterminator.class);
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final byte[] MIME_ID_XLS = new byte[]{-48, -51, 17, -32};
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsSet<MimeTypeContent> m_aMimeTypeContents = new CommonsHashSet<MimeTypeContent>();

    private MimeTypeDeterminator() {
        this._registerDefaultMimeTypeContents();
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _registerDefaultMimeTypeContents() {
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF87A, CMimeType.IMAGE_GIF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF89A, CMimeType.IMAGE_GIF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_JPG, CMimeType.IMAGE_JPG));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PNG, CMimeType.IMAGE_PNG));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_MOTOROLLA, CMimeType.IMAGE_TIFF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_INTEL, CMimeType.IMAGE_TIFF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PSD, CMimeType.IMAGE_PSD));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PDF, CMimeType.APPLICATION_PDF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_XLS, CMimeType.APPLICATION_MS_EXCEL));
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.add(new byte[]{60, 0, 0, 0, 63, 0, 0, 0});
        commonsArrayList.add(new byte[]{0, 60, 0, 0, 0, 63, 0, 0});
        commonsArrayList.add(new byte[]{0, 0, 60, 0, 0, 0, 63, 0});
        commonsArrayList.add(new byte[]{0, 0, 0, 60, 0, 0, 0, 63});
        commonsArrayList.add(new byte[]{0, 60, 0, 63});
        commonsArrayList.add(new byte[]{60, 0, 63, 0});
        commonsArrayList.add(new byte[]{60, 63, 120, 109});
        commonsArrayList.add(new byte[]{76, 111, -89, -108});
        commonsArrayList.forEach(byArray -> this.registerMimeTypeContent(new MimeTypeContent((byte[])byArray, CMimeType.TEXT_XML)));
        for (EUnicodeBOM eUnicodeBOM : EUnicodeBOM.values()) {
            for (byte[] byArray2 : commonsArrayList) {
                byte[] byArray3 = ArrayHelper.getConcatenated(eUnicodeBOM.getAllBytes(), byArray2);
                this.registerMimeTypeContent(new MimeTypeContent(byArray3, CMimeType.TEXT_XML));
            }
        }
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MimeTypeDeterminator getInstance() {
        MimeTypeDeterminator mimeTypeDeterminator = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return mimeTypeDeterminator;
    }

    @Nonnull
    public EChange registerMimeTypeContent(@Nonnull MimeTypeContent mimeTypeContent) {
        ValueEnforcer.notNull(mimeTypeContent, "MimeTypeContent");
        return EChange.valueOf(this.m_aRWLock.writeLocked(() -> this.m_aMimeTypeContents.add(mimeTypeContent)));
    }

    @Nonnull
    public EChange unregisterMimeTypeContent(@Nullable MimeTypeContent mimeTypeContent) {
        if (mimeTypeContent == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(this.m_aRWLock.writeLocked(() -> this.m_aMimeTypeContents.remove(mimeTypeContent)));
    }

    @Nonnull
    public IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset) {
        return this.getMimeTypeFromString(string, charset, DEFAULT_MIME_TYPE);
    }

    @Nullable
    public IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset, @Nullable IMimeType iMimeType) {
        return this.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, charset), iMimeType);
    }

    @Nonnull
    public IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray) {
        return this.getMimeTypeFromBytes(byArray, DEFAULT_MIME_TYPE);
    }

    @Nullable
    public IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray, @Nullable IMimeType iMimeType) {
        if (byArray == null || byArray.length == 0) {
            return iMimeType;
        }
        return this.m_aRWLock.readLocked(() -> {
            for (MimeTypeContent mimeTypeContent : this.m_aMimeTypeContents) {
                if (!mimeTypeContent.matchesBeginning(byArray)) continue;
                return mimeTypeContent.getMimeType();
            }
            return iMimeType;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<MimeTypeContent> getAllMimeTypeContents() {
        return this.m_aRWLock.readLocked(() -> (ICommonsSet)this.m_aMimeTypeContents.getClone());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMimeTypeContents.clear();
            this._registerDefaultMimeTypeContents();
        });
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + MimeTypeDeterminator.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final MimeTypeDeterminator s_aInstance = new MimeTypeDeterminator();

        private SingletonHolder() {
        }
    }
}

