/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.math.CombinationGenerator;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinationGeneratorFlexible<DATATYPE> {
    private final boolean m_bAllowEmpty;
    private final int m_nSlotCount;

    public CombinationGeneratorFlexible(@Nonnegative int n, boolean bl) {
        ValueEnforcer.isGE0(n, "SlotCount");
        this.m_nSlotCount = n;
        this.m_bAllowEmpty = bl;
    }

    public void iterateAllCombinations(@Nonnull ICommonsList<DATATYPE> iCommonsList, @Nonnull Consumer<ICommonsList<DATATYPE>> consumer) {
        int n;
        ValueEnforcer.notNull(iCommonsList, "Elements");
        ValueEnforcer.notNull(consumer, "Callback");
        int n2 = n = this.m_bAllowEmpty ? 0 : 1;
        while (n <= this.m_nSlotCount) {
            if (iCommonsList.isEmpty()) {
                consumer.accept(new CommonsArrayList());
            } else {
                for (ICommonsList iCommonsList2 : new CombinationGenerator<DATATYPE>(iCommonsList, n)) {
                    consumer.accept(iCommonsList2);
                }
            }
            ++n;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<ICommonsList<DATATYPE>> getCombinations(@Nonnull ICommonsList<DATATYPE> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, "Elements");
        CommonsHashSet<ICommonsList<DATATYPE>> commonsHashSet = new CommonsHashSet<ICommonsList<DATATYPE>>();
        this.iterateAllCombinations(iCommonsList, commonsHashSet::add);
        return commonsHashSet;
    }

    public static <DATATYPE> void iterateAllCombinations(@Nonnull ICommonsList<DATATYPE> iCommonsList, boolean bl, @Nonnull Consumer<ICommonsList<DATATYPE>> consumer) {
        new CombinationGeneratorFlexible<DATATYPE>(iCommonsList.size(), bl).iterateAllCombinations(iCommonsList, consumer);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE> ICommonsSet<ICommonsList<DATATYPE>> getCombinations(@Nonnull ICommonsList<DATATYPE> iCommonsList, boolean bl) {
        return new CombinationGeneratorFlexible<DATATYPE>(iCommonsList.size(), bl).getCombinations(iCommonsList);
    }
}

