/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LevenshteinDistance {
    private static final LevenshteinDistance s_aInstance = new LevenshteinDistance();

    private LevenshteinDistance() {
    }

    private static int _getDistance111(@Nonnull char[] cArray, @Nonnegative int n, @Nonnull char[] cArray2, @Nonnegative int n2) {
        int n3;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        for (n3 = 0; n3 <= n; ++n3) {
            nArray[n3] = n3;
        }
        for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            nArray2[0] = i + 1;
            for (n3 = 0; n3 < n; ++n3) {
                int n4 = cArray[n3] == c ? 0 : 1;
                nArray2[n3 + 1] = Math.min(Math.min(nArray2[n3] + 1, nArray[n3 + 1] + 1), nArray[n3] + n4);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n];
    }

    private static int _getDistance(@Nonnull char[] cArray, @Nonnegative int n, @Nonnull char[] cArray2, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnegative int n5) {
        int n6;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        for (n6 = 0; n6 <= n; ++n6) {
            nArray[n6] = n6 * n3;
        }
        for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            nArray2[0] = (i + 1) * n4;
            for (n6 = 0; n6 < n; ++n6) {
                int n7 = cArray[n6] == c ? 0 : n5;
                nArray2[n6 + 1] = Math.min(Math.min(nArray2[n6] + n3, nArray[n6 + 1] + n4), nArray[n6] + n7);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n];
    }

    public static int getDistance(@Nullable char[] cArray, @Nullable char[] cArray2) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        int n3 = n = cArray2 == null ? 0 : cArray2.length;
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        return LevenshteinDistance._getDistance111(cArray, n2, cArray2, n);
    }

    public static int getDistance(@Nullable char[] cArray, @Nullable char[] cArray2, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        int n4;
        ValueEnforcer.isGE0(n, "InsertionCost");
        ValueEnforcer.isGE0(n2, "DeletionCost");
        ValueEnforcer.isGE0(n3, "SubstitutionCost");
        int n5 = cArray == null ? 0 : cArray.length;
        int n6 = n4 = cArray2 == null ? 0 : cArray2.length;
        if (n5 == 0) {
            return n4 * n;
        }
        if (n4 == 0) {
            return n5 * n;
        }
        if (n == 1 && n2 == 1 && n3 == 1) {
            return LevenshteinDistance._getDistance111(cArray, n5, cArray2, n4);
        }
        return LevenshteinDistance._getDistance(cArray, n5, cArray2, n4, n, n2, n3);
    }

    public static int getDistance(@Nullable String string, @Nullable String string2) {
        int n = StringHelper.getLength(string);
        int n2 = StringHelper.getLength(string2);
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        return LevenshteinDistance._getDistance111(string.toCharArray(), n, string2.toCharArray(), n2);
    }

    public static int getDistance(@Nullable String string, @Nullable String string2, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        ValueEnforcer.isGE0(n, "InsertionCost");
        ValueEnforcer.isGE0(n2, "DeletionCost");
        ValueEnforcer.isGE0(n3, "SubstitutionCost");
        int n4 = StringHelper.getLength(string);
        int n5 = StringHelper.getLength(string2);
        if (n4 == 0) {
            return n5 * n;
        }
        if (n5 == 0) {
            return n4 * n;
        }
        if (n == 1 && n2 == 1 && n3 == 1) {
            return LevenshteinDistance._getDistance111(string.toCharArray(), n4, string2.toCharArray(), n5);
        }
        return LevenshteinDistance._getDistance(string.toCharArray(), n4, string2.toCharArray(), n5, n, n2, n3);
    }
}

