/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.PrimitiveCollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsCopyOnWriteArrayList;
import com.helger.commons.collection.ext.CommonsCopyOnWriteArraySet;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.CommonsLinkedList;
import com.helger.commons.collection.ext.CommonsTreeSet;
import com.helger.commons.collection.ext.CommonsVector;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.TypeConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class CollectionTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(ArrayList.class, object -> {
            if (object instanceof Collection) {
                return new CommonsArrayList<Collection>((Collection)object);
            }
            return new CommonsArrayList<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Vector.class, object -> {
            if (object instanceof Collection) {
                return new CommonsVector<Collection>((Collection)object);
            }
            return new CommonsVector<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(LinkedList.class, object -> {
            if (object instanceof Collection) {
                return new CommonsLinkedList<Collection>((Collection)object);
            }
            return new CommonsLinkedList<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArrayList.class, object -> {
            if (object instanceof Collection) {
                return new CommonsCopyOnWriteArrayList<Collection>((Collection)object);
            }
            return new CommonsCopyOnWriteArrayList<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(List.class, object -> {
            if (object instanceof Collection) {
                return new CommonsArrayList<Collection>((Collection)object);
            }
            return new CommonsArrayList<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(TreeSet.class, object -> {
            if (object instanceof Collection) {
                return new CommonsTreeSet<Collection>((Collection)object);
            }
            return new CommonsTreeSet<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(LinkedHashSet.class, object -> {
            if (object instanceof Collection) {
                return new CommonsLinkedHashSet<Collection>((Collection)object);
            }
            return new CommonsLinkedHashSet<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArraySet.class, object -> {
            if (object instanceof Collection) {
                return new CommonsCopyOnWriteArraySet<Collection>((Collection)object);
            }
            return new CommonsCopyOnWriteArraySet<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Set.class, object -> {
            if (object instanceof Collection) {
                return new CommonsHashSet<Collection>((Collection)object);
            }
            return new CommonsHashSet<Object>(object);
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, String.class, Base64::encodeBytes);
        iTypeConverterRegistry.registerTypeConverter(String.class, byte[].class, Base64::safeDecode);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(byte[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, String.class, cArray -> new String((char[])cArray));
        iTypeConverterRegistry.registerTypeConverter(String.class, char[].class, string -> string.toCharArray());
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(char[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(double[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(float[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(int[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(long[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsArrayList.class, PrimitiveCollectionHelper::newPrimitiveList);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsVector.class, PrimitiveCollectionHelper::newPrimitiveVector);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsHashSet.class, PrimitiveCollectionHelper::newPrimitiveSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsLinkedHashSet.class, PrimitiveCollectionHelper::newPrimitiveOrderedSet);
        iTypeConverterRegistry.registerTypeConverter(short[].class, CommonsTreeSet.class, PrimitiveCollectionHelper::newPrimitiveSortedSet);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(boolean[].class, object -> {
            boolean[] blArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    blArray[i] = TypeConverter.convertToBoolean(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                blArray = new boolean[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    blArray[n++] = TypeConverter.convertToBoolean(e);
                }
            } else {
                blArray = new boolean[]{TypeConverter.convertToBoolean(object)};
            }
            return blArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(byte[].class, object -> {
            byte[] byArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    byArray[i] = TypeConverter.convertToByte(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                byArray = new byte[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    byArray[n++] = TypeConverter.convertToByte(e);
                }
            } else {
                byArray = new byte[]{TypeConverter.convertToByte(object)};
            }
            return byArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(char[].class, object -> {
            char[] cArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    cArray[i] = TypeConverter.convertToChar(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                cArray = new char[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    cArray[n++] = TypeConverter.convertToChar(e);
                }
            } else {
                cArray = new char[]{TypeConverter.convertToChar(object)};
            }
            return cArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(double[].class, object -> {
            double[] dArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    dArray[i] = TypeConverter.convertToDouble(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                dArray = new double[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    dArray[n++] = TypeConverter.convertToDouble(e);
                }
            } else {
                dArray = new double[]{TypeConverter.convertToDouble(object)};
            }
            return dArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(float[].class, object -> {
            float[] fArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    fArray[i] = TypeConverter.convertToFloat(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                fArray = new float[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    fArray[n++] = TypeConverter.convertToFloat(e);
                }
            } else {
                fArray = new float[]{TypeConverter.convertToFloat(object)};
            }
            return fArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(int[].class, object -> {
            int[] nArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    nArray[i] = TypeConverter.convertToInt(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                nArray = new int[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    nArray[n++] = TypeConverter.convertToInt(e);
                }
            } else {
                nArray = new int[]{TypeConverter.convertToInt(object)};
            }
            return nArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(long[].class, object -> {
            long[] lArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    lArray[i] = TypeConverter.convertToLong(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                lArray = new long[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    lArray[n++] = TypeConverter.convertToLong(e);
                }
            } else {
                lArray = new long[]{TypeConverter.convertToLong(object)};
            }
            return lArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(short[].class, object -> {
            short[] sArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    sArray[i] = TypeConverter.convertToShort(object2);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                sArray = new short[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    sArray[n++] = TypeConverter.convertToShort(e);
                }
            } else {
                sArray = new short[]{TypeConverter.convertToShort(object)};
            }
            return sArray;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(String[].class, object -> {
            String[] stringArray;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    stringArray[i] = TypeConverter.convertIfNecessary(object2, String.class);
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                stringArray = new String[collection.size()];
                int n = 0;
                for (Object e : collection) {
                    stringArray[n++] = TypeConverter.convertIfNecessary(e, String.class);
                }
            } else {
                stringArray = new String[]{TypeConverter.convertIfNecessary(object, String.class)};
            }
            return stringArray;
        });
    }
}

