/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.CommonsTreeMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsSortedMap<KEYTYPE, VALUETYPE>
extends SortedMap<KEYTYPE, VALUETYPE>,
ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <K, V> ICommonsSortedMap<K, V> createInstance() {
        return new CommonsTreeMap();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsLinkedHashSet(this.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        return new CommonsLinkedHashSet(this.entrySet());
    }

    @Override
    @Nullable
    default public KEYTYPE getFirstKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.firstKey());
    }

    @Override
    @Nullable
    default public VALUETYPE getFirstValue(@Nullable VALUETYPE VALUETYPE) {
        Object var2_2 = this.getFirstKey(null);
        return (VALUETYPE)(var2_2 == null ? VALUETYPE : this.get(var2_2));
    }

    @Nullable
    default public KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    @Nullable
    default public KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.lastKey());
    }

    @Nullable
    default public VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    @Nullable
    default public VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        Object var2_2 = this.getLastKey(null);
        return (VALUETYPE)(var2_2 == null ? VALUETYPE : this.get(var2_2));
    }

    @Override
    @Nonnull
    @CodingStyleguideUnaware
    default public SortedMap<KEYTYPE, VALUETYPE> getAsUnmodifiable() {
        return Collections.unmodifiableSortedMap(this);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSortedMap<KEYTYPE, VALUETYPE> getClone();
}

