/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResourceErrorGroup
implements IResourceErrorGroup,
ICloneable<ResourceErrorGroup>,
IClearable {
    private final ICommonsList<IResourceError> m_aErrors = new CommonsArrayList<IResourceError>();

    public ResourceErrorGroup() {
    }

    public ResourceErrorGroup(@Nonnull IResourceError iResourceError) {
        this.addResourceError(iResourceError);
    }

    public ResourceErrorGroup(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
    }

    public ResourceErrorGroup(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
    }

    @Nonnull
    public final ResourceErrorGroup addResourceError(@Nonnull IResourceError iResourceError) {
        ValueEnforcer.notNull(iResourceError, "ResourceError");
        this.m_aErrors.add(iResourceError);
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public final ResourceErrorGroup addResourceErrorGroup(@Nonnull IResourceErrorGroup iResourceErrorGroup) {
        ValueEnforcer.notNull(iResourceErrorGroup, "ResourceErrorGroup");
        this.m_aErrors.addAll(iResourceErrorGroup.getAllResourceErrors());
        return this;
    }

    @Override
    public boolean containsOnlySuccess() {
        return this.m_aErrors.containsOnly(iResourceError -> iResourceError.isSuccess());
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        return this.m_aErrors.containsAny(iResourceError -> iResourceError.isSuccess());
    }

    @Override
    public boolean containsNoSuccess() {
        return this.m_aErrors.containsNone(iResourceError -> iResourceError.isSuccess());
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        return this.m_aErrors.getCount(iResourceError -> iResourceError.isSuccess());
    }

    @Override
    public boolean containsOnlyFailure() {
        return this.m_aErrors.containsOnly(iResourceError -> iResourceError.isFailure());
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        return this.m_aErrors.containsAny(iResourceError -> iResourceError.isFailure());
    }

    @Override
    public boolean containsNoFailure() {
        return this.m_aErrors.containsNone(iResourceError -> iResourceError.isFailure());
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        return this.m_aErrors.getCount(iResourceError -> iResourceError.isFailure());
    }

    @Override
    public boolean containsOnlyError() {
        return this.m_aErrors.containsOnly(iResourceError -> iResourceError.isError());
    }

    @Override
    public boolean containsAtLeastOneError() {
        return this.m_aErrors.containsAny(iResourceError -> iResourceError.isError());
    }

    @Override
    public boolean containsNoError() {
        return this.m_aErrors.containsNone(iResourceError -> iResourceError.isError());
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        return this.m_aErrors.getCount(iResourceError -> iResourceError.isError());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllFailures() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        this.m_aErrors.findAll(iResourceError -> iResourceError.isFailure(), resourceErrorGroup::addResourceError);
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllErrors() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        this.m_aErrors.findAll(iResourceError -> iResourceError.isError(), resourceErrorGroup::addResourceError);
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    public IErrorLevel getMostSevereErrorLevel() {
        IResourceError iResourceError;
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = EErrorLevel.SUCCESS;
        Iterator iterator = this.m_aErrors.iterator();
        while (!(!iterator.hasNext() || (iErrorLevel = (iResourceError = (IResourceError)iterator.next()).getErrorLevel()).isMoreSevereThan(iErrorLevel2) && (iErrorLevel2 = iErrorLevel).isHighest())) {
        }
        return iErrorLevel2;
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aErrors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getClone() {
        return new ResourceErrorGroup(this.m_aErrors);
    }

    @Override
    @Nonnull
    public Iterator<IResourceError> iterator() {
        return this.m_aErrors.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IResourceError> getAllResourceErrors() {
        return (ICommonsList)this.m_aErrors.getClone();
    }

    @Override
    public void forEachResourceError(@Nonnull Consumer<? super IResourceError> consumer) {
        this.m_aErrors.forEach(consumer);
    }

    @Override
    @Nonnull
    public EChange clear() {
        return this.m_aErrors.removeAll();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceErrorGroup resourceErrorGroup = (ResourceErrorGroup)object;
        return this.m_aErrors.equals(resourceErrorGroup.m_aErrors);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aErrors)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("errors", this.m_aErrors).toString();
    }
}

