/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import java.security.InvalidKeyException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.ExemptionMechanism;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CryptoPolicy {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CryptoPolicy.class);
    private static final AtomicBoolean s_aChecked = new AtomicBoolean(false);
    private static boolean s_bUnlimitedStrength;
    private static final CryptoPolicy s_aInstance;

    private CryptoPolicy() {
    }

    private static boolean _isUnlimitedStrengthAvailable() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, secretKeySpec);
            byte[] byArray2 = cipher.doFinal(CharsetManager.getAsBytes("1234567890123456", CCharset.CHARSET_ISO_8859_1_OBJ));
            if (byArray2 == null) {
                throw new IllegalStateException("Encryption of test string failed!");
            }
            ExemptionMechanism exemptionMechanism = cipher.getExemptionMechanism();
            if (exemptionMechanism != null) {
                s_aLogger.info("Cipher uses exemption mechanism " + exemptionMechanism.getName());
                return false;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            s_aLogger.info("Invalid key size - unlimited strength crypto NOT installed!");
            return false;
        }
        catch (Exception exception) {
            s_aLogger.info("Failed to determine unlimited strength crypto state", (Throwable)exception);
            return false;
        }
        return true;
    }

    public static boolean isUnlimitedStrengthCryptoAvailable() {
        if (!s_aChecked.getAndSet(true)) {
            s_bUnlimitedStrength = CryptoPolicy._isUnlimitedStrengthAvailable();
        }
        return s_bUnlimitedStrength;
    }

    static {
        s_aInstance = new CryptoPolicy();
    }
}

