/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.changelog;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.changelog.AbstractChangeLogEntry;
import com.helger.commons.changelog.ChangeLogEntry;
import com.helger.commons.changelog.ChangeLogRelease;
import com.helger.commons.changelog.EChangeLogCategory;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ChangeLog
implements Serializable {
    private final String m_sOriginalVersion;
    private final Version m_aVersion;
    private final String m_sComponent;
    private final ICommonsList<AbstractChangeLogEntry> m_aEntries = new CommonsArrayList<AbstractChangeLogEntry>();

    public ChangeLog(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.m_sOriginalVersion = ValueEnforcer.notEmpty(string, "Version");
        this.m_aVersion = Version.parse(string);
        this.m_sComponent = ValueEnforcer.notEmpty(string2, "Component");
    }

    @Nonnull
    @Nonempty
    public String getOriginalVersion() {
        return this.m_sOriginalVersion;
    }

    @Nonnull
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Nonnull
    @Nonempty
    public String getComponent() {
        return this.m_sComponent;
    }

    public void addEntry(@Nonnull ChangeLogEntry changeLogEntry) {
        ValueEnforcer.notNull(changeLogEntry, "Entry");
        this.m_aEntries.add(changeLogEntry);
    }

    public void addEntry(@Nonnegative int n, @Nonnull ChangeLogEntry changeLogEntry) {
        ValueEnforcer.notNull(changeLogEntry, "Entry");
        this.m_aEntries.add(n, changeLogEntry);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<AbstractChangeLogEntry> getAllBaseEntries() {
        return (ICommonsList)this.m_aEntries.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ChangeLogEntry> getAllEntries() {
        return this.m_aEntries.getAllInstanceOf(ChangeLogEntry.class);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ChangeLogEntry> getAllEntriesOfCategory(@Nonnull EChangeLogCategory eChangeLogCategory) {
        ValueEnforcer.notNull(eChangeLogCategory, "Category");
        CommonsArrayList<ChangeLogEntry> commonsArrayList = new CommonsArrayList<ChangeLogEntry>();
        this.m_aEntries.findAllInstanceOf(ChangeLogEntry.class, changeLogEntry -> {
            if (changeLogEntry.getCategory().equals(eChangeLogCategory)) {
                commonsArrayList.add(changeLogEntry);
            }
        });
        return commonsArrayList;
    }

    public void addRelease(@Nonnull ChangeLogRelease changeLogRelease) {
        ValueEnforcer.notNull(changeLogRelease, "Release");
        this.m_aEntries.add(changeLogRelease);
    }

    public void addRelease(@Nonnegative int n, @Nonnull ChangeLogRelease changeLogRelease) {
        ValueEnforcer.notNull(changeLogRelease, "Release");
        this.m_aEntries.add(n, changeLogRelease);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ChangeLogRelease> getAllReleases() {
        return this.m_aEntries.getAllInstanceOf(ChangeLogRelease.class);
    }

    @Nullable
    public ChangeLogRelease getLatestRelease() {
        ChangeLogRelease changeLogRelease = null;
        for (AbstractChangeLogEntry abstractChangeLogEntry : this.m_aEntries) {
            if (!(abstractChangeLogEntry instanceof ChangeLogRelease)) continue;
            ChangeLogRelease changeLogRelease2 = (ChangeLogRelease)abstractChangeLogEntry;
            if (changeLogRelease != null && !changeLogRelease2.getDate().isAfter(changeLogRelease.getDate())) continue;
            changeLogRelease = changeLogRelease2;
        }
        return changeLogRelease;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ChangeLog changeLog = (ChangeLog)object;
        return this.m_sOriginalVersion.equals(changeLog.m_sOriginalVersion) && this.m_aVersion.equals(changeLog.m_aVersion) && this.m_sComponent.equals(changeLog.m_sComponent) && this.m_aEntries.equals(changeLog.m_aEntries);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sOriginalVersion).append(this.m_aVersion).append(this.m_sComponent).append(this.m_aEntries)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("originalVersion", this.m_sOriginalVersion).append("version", this.m_aVersion).append("component", this.m_sComponent).append("entries", this.m_aEntries).toString();
    }
}

