/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.collection.impl.LRUMap;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClassHierarchyCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ClassHierarchyCache.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, ClassList> s_aClassHierarchy = new LRUMap<String, ClassList>(1000);
    private static final ClassHierarchyCache s_aInstance = new ClassHierarchyCache();

    private ClassHierarchyCache() {
    }

    @Nonnull
    public static EChange clearCache() {
        return s_aRWLock.writeLocked(() -> {
            if (s_aClassHierarchy.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aClassHierarchy.clear();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was cleared: " + ClassHierarchyCache.class.getName());
            }
            return EChange.CHANGED;
        });
    }

    @Nonnull
    static ClassList getClassList(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        ClassList classList = s_aRWLock.readLocked(() -> (ClassList)s_aClassHierarchy.get(string));
        if (classList == null) {
            classList = s_aRWLock.writeLocked(() -> {
                ClassList classList = (ClassList)s_aClassHierarchy.get(string);
                if (classList == null) {
                    classList = new ClassList(clazz);
                    s_aClassHierarchy.put(string, classList);
                }
                return classList;
            });
        }
        return classList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<Class<?>> getClassHierarchy(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz).getAsSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Class<?>> getClassHierarchyList(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz).getAsList();
    }

    @Nonnull
    public static Iterable<WeakReference<Class<?>>> getClassHierarchyIterator(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz);
    }

    @Immutable
    private static final class ClassList
    implements Iterable<WeakReference<Class<?>>> {
        private final ICommonsList<WeakReference<Class<?>>> m_aList = new CommonsArrayList();

        public ClassList(@Nonnull Class<?> clazz) {
            ValueEnforcer.notNull(clazz, "Class");
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            commonsArrayList.add(clazz);
            while (!commonsArrayList.isEmpty()) {
                Class clazz2 = (Class)commonsArrayList.removeFirst();
                commonsLinkedHashSet.add(clazz2);
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    commonsArrayList.add(0, clazz3);
                }
                if (clazz2.getSuperclass() == null) continue;
                commonsArrayList.add(0, clazz2.getSuperclass());
            }
            for (Class<?>[] classArray : commonsLinkedHashSet) {
                this.m_aList.add(new WeakReference<Class<?>[]>(classArray));
            }
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsOrderedSet<Class<?>> getAsSet() {
            CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsLinkedHashSet.add(clazz);
            }
            return commonsLinkedHashSet;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<Class<?>> getAsList() {
            CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(this.m_aList.size());
            for (WeakReference weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add(clazz);
            }
            return commonsArrayList;
        }

        @Override
        @Nonnull
        public IIterableIterator<WeakReference<Class<?>>> iterator() {
            return this.m_aList.iterator2();
        }

        public String toString() {
            return new ToStringGenerator(this).append("list", this.m_aList).toString();
        }
    }
}

