/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@IsSPIImplementation
@Immutable
public final class BasicSerializationConverterRegistrar
implements ISerializationConverterRegistrarSPI {
    @Override
    public void registerSerializationConverter(@Nonnull ISerializationConverterRegistry iSerializationConverterRegistry) {
        iSerializationConverterRegistry.registerSerializationConverter(Charset.class, new SerializationConverterCharset());
    }

    private static final class SerializationConverterCharset
    implements ISerializationConverter<Charset> {
        private SerializationConverterCharset() {
        }

        @Override
        public void writeConvertedObject(@Nonnull Charset charset, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(charset.name());
        }

        @Override
        public Charset readConvertedObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
            String string = objectInputStream.readUTF();
            return CharsetManager.getCharsetFromName(string);
        }
    }
}

