/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.ws;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiLinkedHashMapArrayListBased;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import com.helger.commons.random.VerySecureRandom;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.ws.HostnameVerifierVerifyAll;
import com.helger.commons.ws.TrustManagerTrustAll;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class WSClientConfig {
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 5000;
    private static final Logger s_aLogger = LoggerFactory.getLogger(WSClientConfig.class);
    private final URL m_aEndpointAddress;
    private SSLSocketFactory m_aSSLSocketFactory;
    private HostnameVerifier m_aHostnameVerifier;
    private int m_nConnectionTimeoutMS = 5000;
    private int m_nRequestTimeoutMS = 5000;
    private String m_sUserName;
    private String m_sPassword;
    private String m_sSOAPAction;
    private IMultiMapListBased<String, String> m_aHTTPHeaders;
    private ETriState m_eCookiesSupport = ETriState.UNDEFINED;
    private final ICommonsList<Handler<? extends MessageContext>> m_aHandlers = new CommonsArrayList<Handler<? extends MessageContext>>();
    private boolean m_bWorkAroundMASM0003 = true;

    public WSClientConfig(@Nullable URL uRL) {
        this.m_aEndpointAddress = uRL;
        if (s_aLogger.isDebugEnabled() && uRL != null) {
            s_aLogger.debug("Using endpoint address '" + this.m_aEndpointAddress.toExternalForm() + "'");
        }
    }

    @Nullable
    public URL getEndpointAddress() {
        return this.m_aEndpointAddress;
    }

    @Nullable
    public SSLSocketFactory getSSLSocketFactory() {
        return this.m_aSSLSocketFactory;
    }

    @Nonnull
    public WSClientConfig setSSLSocketFactoryTrustAll() throws KeyManagementException {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll()}, VerySecureRandom.getInstance());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return this.setSSLSocketFactory(sSLSocketFactory);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("TLS is not supported", noSuchAlgorithmException);
        }
    }

    @Nonnull
    public WSClientConfig setSSLSocketFactory(@Nullable SSLSocketFactory sSLSocketFactory) {
        this.m_aSSLSocketFactory = sSLSocketFactory;
        return this;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.m_aHostnameVerifier;
    }

    @Nonnull
    public WSClientConfig setHostnameVerifierTrustAll() {
        return this.setHostnameVerifier(new HostnameVerifierVerifyAll());
    }

    @Nonnull
    public WSClientConfig setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.m_aHostnameVerifier = hostnameVerifier;
        return this;
    }

    public int getConnectionTimeoutMS() {
        return this.m_nConnectionTimeoutMS;
    }

    @Nonnull
    public WSClientConfig setConnectionTimeoutMS(int n) {
        this.m_nConnectionTimeoutMS = n;
        return this;
    }

    public int getRequestTimeoutMS() {
        return this.m_nRequestTimeoutMS;
    }

    @Nonnull
    public WSClientConfig setRequestTimeoutMS(int n) {
        this.m_nRequestTimeoutMS = n;
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.m_sUserName;
    }

    public boolean hasUserName() {
        return StringHelper.hasText(this.m_sUserName);
    }

    @Nonnull
    public WSClientConfig setUserName(@Nullable String string) {
        this.m_sUserName = string;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        return StringHelper.hasText(this.m_sPassword);
    }

    @Nonnull
    public WSClientConfig setPassword(@Nullable String string) {
        this.m_sPassword = string;
        return this;
    }

    @Nullable
    public String getSOAPAction() {
        return this.m_sSOAPAction;
    }

    public boolean hasSOAPAction() {
        return StringHelper.hasText(this.m_sSOAPAction);
    }

    @Nonnull
    public WSClientConfig setSOAPAction(@Nullable String string) {
        this.m_sSOAPAction = string;
        return this;
    }

    @Nonnull
    private IMultiMapListBased<String, String> _getHeaderMap() {
        if (this.m_aHTTPHeaders == null) {
            this.m_aHTTPHeaders = new MultiLinkedHashMapArrayListBased<String, String>();
        }
        return this.m_aHTTPHeaders;
    }

    @Nonnull
    public WSClientConfig addHTTPHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        this._getHeaderMap().putSingle(string, string2);
        return this;
    }

    @Nonnull
    public WSClientConfig addHTTPHeader(@Nonnull @Nonempty String string, @Nonnull Collection<String> collection) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNullNoNullValue(collection, "Values");
        ((ICommonsList)this._getHeaderMap().getOrCreate(string)).addAll(collection);
        return this;
    }

    @Nonnull
    public WSClientConfig setHTTPHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        this._getHeaderMap().put(string, new CommonsArrayList<String>(string2));
        return this;
    }

    @Nonnull
    public WSClientConfig setHTTPHeader(@Nonnull @Nonempty String string, @Nonnull Collection<String> collection) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNullNoNullValue(collection, "Values");
        if (collection.isEmpty()) {
            this.removeHTTPHeader(string);
        } else {
            this._getHeaderMap().put(string, new CommonsArrayList<Collection<String>>(collection));
        }
        return this;
    }

    @Nonnull
    public EChange removeHTTPHeader(@Nonnull String string) {
        if (this.m_aHTTPHeaders == null || StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        return this.m_aHTTPHeaders.removeObject(string);
    }

    @Nonnull
    public EChange removeHTTPHeader(@Nullable String string, @Nullable String string2) {
        if (this.m_aHTTPHeaders == null || StringHelper.hasNoText(string) || string2 == null) {
            return EChange.UNCHANGED;
        }
        ICommonsList iCommonsList = (ICommonsList)this.m_aHTTPHeaders.get(string);
        if (iCommonsList != null && iCommonsList.remove(string2)) {
            if (iCommonsList.isEmpty()) {
                this.m_aHTTPHeaders.remove(string);
            }
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    public boolean containsHTTPHeader(@Nullable String string) {
        if (this.m_aHTTPHeaders == null || StringHelper.hasNoText(string)) {
            return false;
        }
        return CollectionHelper.isNotEmpty((Collection)this.m_aHTTPHeaders.get(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHTTPHeaderValues(@Nullable String string) {
        if (this.m_aHTTPHeaders == null || StringHelper.hasNoText(string)) {
            return new CommonsArrayList<boolean>(false);
        }
        return new CommonsArrayList<Collection>((Collection)this.m_aHTTPHeaders.get(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ICommonsList<String>> getAllHTTPHeaders() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aHTTPHeaders);
    }

    @Nonnull
    public WSClientConfig setCompressedRequest(boolean bl) {
        if (bl) {
            this.setHTTPHeader("Content-Encoding", "gzip");
        } else {
            this.removeHTTPHeader("Content-Encoding");
        }
        return this;
    }

    @Nonnull
    public WSClientConfig setCompressedResponse(boolean bl) {
        if (bl) {
            this.setHTTPHeader("Accept-Encoding", "gzip");
        } else {
            this.removeHTTPHeader("Accept-Encoding");
        }
        return this;
    }

    public boolean isCookiesSupportEnabled() {
        return this.m_eCookiesSupport.isTrue();
    }

    @Nonnull
    public WSClientConfig setCookiesSupportEnabled(boolean bl) {
        this.m_eCookiesSupport = ETriState.valueOf(bl);
        return this;
    }

    @Nonnull
    public WSClientConfig addHandler(@Nonnull Handler<? extends MessageContext> handler) {
        ValueEnforcer.notNull(handler, "Handler");
        this.m_aHandlers.add(handler);
        return this;
    }

    @Nonnegative
    public int getHandlerCount() {
        return this.m_aHandlers.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Handler<? extends MessageContext>> getAllHandlers() {
        return (ICommonsList)this.m_aHandlers.getClone();
    }

    @OverrideOnDemand
    protected void customizeRequestContext(@Nonnull Map<String, Object> map) {
    }

    protected final boolean isWorkAroundMASM0003() {
        return this.m_bWorkAroundMASM0003;
    }

    protected final WSClientConfig setWorkAroundMASM0003(boolean bl) {
        this.m_bWorkAroundMASM0003 = bl;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void applyWSSettingsToBindingProvider(@Nonnull BindingProvider bindingProvider) {
        Object object;
        Map map = bindingProvider.getRequestContext();
        if (this.m_aEndpointAddress != null) {
            map.put("javax.xml.ws.service.endpoint.address", this.m_aEndpointAddress.toExternalForm());
        }
        if (this.m_aSSLSocketFactory != null) {
            map.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.m_aSSLSocketFactory);
            map.put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", this.m_aSSLSocketFactory);
        }
        if (this.m_aHostnameVerifier != null) {
            map.put("com.sun.xml.ws.transport.https.client.hostname.verifier", this.m_aHostnameVerifier);
            map.put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", this.m_aHostnameVerifier);
        }
        if (this.m_nConnectionTimeoutMS >= 0) {
            map.put("com.sun.xml.ws.connect.timeout", this.m_nConnectionTimeoutMS);
            map.put("com.sun.xml.internal.ws.connect.timeout", this.m_nConnectionTimeoutMS);
        }
        if (this.m_nRequestTimeoutMS >= 0) {
            map.put("com.sun.xml.ws.request.timeout", this.m_nRequestTimeoutMS);
            map.put("com.sun.xml.internal.ws.request.timeout", this.m_nRequestTimeoutMS);
        }
        if (StringHelper.hasText(this.m_sUserName)) {
            map.put("javax.xml.ws.security.auth.username", this.m_sUserName);
            map.put("javax.xml.ws.security.auth.password", this.m_sPassword);
        }
        if (this.hasSOAPAction()) {
            map.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            map.put("javax.xml.ws.soap.http.soapaction.uri", this.m_sSOAPAction);
        }
        if (CollectionHelper.isNotEmpty(this.m_aHTTPHeaders)) {
            map.put("javax.xml.ws.http.request.headers", this.m_aHTTPHeaders);
        }
        if (this.m_eCookiesSupport.isDefined()) {
            map.put("javax.xml.ws.session.maintain", this.m_eCookiesSupport.getAsBooleanObj());
        }
        if (this.m_aHandlers.isNotEmpty()) {
            object = bindingProvider.getBinding().getHandlerChain();
            object.addAll(this.m_aHandlers);
            bindingProvider.getBinding().setHandlerChain((List)object);
        }
        this.customizeRequestContext(map);
        if (this.m_bWorkAroundMASM0003) {
            object = ClassLoaderHelper.getContextClassLoader();
            ClassLoader classLoader = IPrivilegedAction.getClassLoader(this.getClass()).invokeSafe();
            if (object == null) {
                s_aLogger.info("Manually setting thread context class loader to work around MASM0003 bug");
                ClassLoaderHelper.setContextClassLoader(classLoader);
            } else if (object != classLoader) {
                s_aLogger.warn("Manually overriding thread context class loader to work around MASM0003 bug");
                ClassLoaderHelper.setContextClassLoader(classLoader);
            }
        }
    }
}

