/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.map;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.map.MapHelper;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IntFloatMap
implements Serializable {
    private static final int FREE_KEY = 0;
    public static final float NO_VALUE = Float.NEGATIVE_INFINITY;
    private int[] m_aKeys;
    private float[] m_aValues;
    private boolean m_bHasFreeKey;
    private float m_aFreeValue = Float.NEGATIVE_INFINITY;
    private final float m_fFillFactor;
    private int m_nThreshold;
    private int m_nSize;
    private int m_nMask;

    public IntFloatMap() {
        this(16);
    }

    public IntFloatMap(int n) {
        this(n, 0.75f);
    }

    public IntFloatMap(int n, float f) {
        ValueEnforcer.isBetweenInclusive(f, "FillFactor", 0.0f, 1.0f);
        ValueEnforcer.isGT0(n, "Size");
        int n2 = MapHelper.arraySize(n, f);
        this.m_nMask = n2 - 1;
        this.m_fFillFactor = f;
        this.m_aKeys = new int[n2];
        this.m_aValues = IntFloatMap._createValueArray(n2);
        this.m_nThreshold = (int)((float)n2 * f);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static float[] _createValueArray(@Nonnegative int n) {
        float[] fArray = new float[n];
        Arrays.fill(fArray, Float.NEGATIVE_INFINITY);
        return fArray;
    }

    public float get(int n) {
        return this.get(n, Float.NEGATIVE_INFINITY);
    }

    public float get(int n, float f) {
        if (n == 0) {
            return this.m_bHasFreeKey ? this.m_aFreeValue : f;
        }
        int n2 = this._getReadIndex(n);
        return n2 != -1 ? this.m_aValues[n2] : f;
    }

    public float put(int n, float f) {
        if (n == 0) {
            float f2 = this.m_aFreeValue;
            if (!this.m_bHasFreeKey) {
                ++this.m_nSize;
                this.m_bHasFreeKey = true;
            }
            this.m_aFreeValue = f;
            return f2;
        }
        int n2 = this._getPutIndex(n);
        if (n2 < 0) {
            this._rehash(this.m_aKeys.length * 2);
            n2 = this._getPutIndex(n);
        }
        float f3 = this.m_aValues[n2];
        if (this.m_aKeys[n2] != n) {
            this.m_aKeys[n2] = n;
            this.m_aValues[n2] = f;
            ++this.m_nSize;
            if (this.m_nSize >= this.m_nThreshold) {
                this._rehash(this.m_aKeys.length * 2);
            }
        } else {
            assert (this.m_aKeys[n2] == n);
            this.m_aValues[n2] = f;
        }
        return f3;
    }

    public float remove(int n) {
        if (n == 0) {
            if (!this.m_bHasFreeKey) {
                return Float.NEGATIVE_INFINITY;
            }
            this.m_bHasFreeKey = false;
            float f = this.m_aFreeValue;
            this.m_aFreeValue = Float.NEGATIVE_INFINITY;
            --this.m_nSize;
            return f;
        }
        int n2 = this._getReadIndex(n);
        if (n2 == -1) {
            return Float.NEGATIVE_INFINITY;
        }
        float f = this.m_aValues[n2];
        this.m_aValues[n2] = Float.NEGATIVE_INFINITY;
        this._shiftKeys(n2);
        --this.m_nSize;
        return f;
    }

    @Nonnegative
    public int size() {
        return this.m_nSize;
    }

    private void _rehash(int n) {
        this.m_nThreshold = (int)((float)n * this.m_fFillFactor);
        this.m_nMask = n - 1;
        int n2 = this.m_aKeys.length;
        int[] nArray = this.m_aKeys;
        float[] fArray = this.m_aValues;
        this.m_aKeys = new int[n];
        this.m_aValues = IntFloatMap._createValueArray(n);
        this.m_nSize = this.m_bHasFreeKey ? 1 : 0;
        int n3 = n2;
        while (n3-- > 0) {
            if (nArray[n3] == 0) continue;
            this.put(nArray[n3], fArray[n3]);
        }
    }

    private int _shiftKeys(int n) {
        int n2 = n;
        int[] nArray = this.m_aKeys;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = this._getNextIndex(n2);
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.m_aValues[n4] = Float.NEGATIVE_INFINITY;
                    return n4;
                }
                int n5 = MapHelper.phiMix(n3) & this.m_nMask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = this._getNextIndex(n2);
            }
            nArray[n4] = n3;
            this.m_aValues[n4] = this.m_aValues[n2];
        }
    }

    @CheckForSigned
    private int _getReadIndex(int n) {
        int n2 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n2] == n) {
            return n2;
        }
        if (this.m_aKeys[n2] == 0) {
            return -1;
        }
        int n3 = n2;
        while ((n2 = this._getNextIndex(n2)) != n3) {
            if (this.m_aKeys[n2] == 0) {
                return -1;
            }
            if (this.m_aKeys[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @CheckForSigned
    private int _getPutIndex(int n) {
        int n2 = this._getReadIndex(n);
        if (n2 >= 0) {
            return n2;
        }
        int n3 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n3] == 0) {
            return n3;
        }
        int n4 = n3;
        while (this.m_aKeys[n4] != 0) {
            if ((n4 = this._getNextIndex(n4)) != n3) continue;
            return -1;
        }
        return n4;
    }

    private int _getNextIndex(int n) {
        return n + 1 & this.m_nMask;
    }
}

