/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiLinkedHashMapArrayListBased;
import com.helger.commons.error.IHasErrorLevels;
import com.helger.commons.errorlist.IError;
import com.helger.commons.errorlist.IFieldErrorList;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IErrorList
extends Iterable<IError>,
IHasErrorLevels,
IFieldErrorList,
Serializable {
    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nonnegative
    public int getItemCount();

    public boolean hasErrorsOrWarnings();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IError> getAllItems();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTexts();

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getListWithoutField();

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public IMultiMapListBased<String, IError> getGroupedByID() {
        MultiLinkedHashMapArrayListBased<String, IError> multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased<String, IError>();
        this.forEach(iError -> multiLinkedHashMapArrayListBased.putSingle(iError.getErrorID(), (IError)iError));
        return multiLinkedHashMapArrayListBased;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public IMultiMapListBased<String, IError> getGroupedByFieldName() {
        MultiLinkedHashMapArrayListBased<String, IError> multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased<String, IError>();
        this.forEach(iError -> multiLinkedHashMapArrayListBased.putSingle(iError.getErrorFieldName(), (IError)iError));
        return multiLinkedHashMapArrayListBased;
    }
}

