/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.errorlist.IError;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SingleError
implements IError {
    private final String m_sErrorID;
    private final IErrorLevel m_aErrorLevel;
    private final String m_sErrorFieldName;
    private final String m_sErrorText;

    public SingleError(@Nonnull IErrorLevel iErrorLevel, @Nonnull @Nonempty String string) {
        this(iErrorLevel, null, string);
    }

    public SingleError(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nonnull @Nonempty String string2) {
        this(null, iErrorLevel, string, string2);
    }

    public SingleError(@Nullable String string, @Nonnull IErrorLevel iErrorLevel, @Nullable String string2, @Nonnull @Nonempty String string3) {
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notEmpty(string3, "ErrorText");
        this.m_sErrorID = string;
        this.m_aErrorLevel = iErrorLevel;
        this.m_sErrorFieldName = string2;
        this.m_sErrorText = string3;
    }

    @Override
    @Nullable
    public String getErrorID() {
        return this.m_sErrorID;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    @Nullable
    public String getErrorFieldName() {
        return this.m_sErrorFieldName;
    }

    @Override
    @Nonnull
    public String getErrorText() {
        return this.m_sErrorText;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleError singleError = (SingleError)object;
        return EqualsHelper.equals(this.m_sErrorID, singleError.m_sErrorID) && this.m_aErrorLevel.equals(singleError.m_aErrorLevel) && EqualsHelper.equals(this.m_sErrorFieldName, singleError.m_sErrorFieldName) && this.m_sErrorText.equals(singleError.m_sErrorText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sErrorID).append(this.m_aErrorLevel).append(this.m_sErrorFieldName).append(this.m_sErrorText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("errorID", this.m_sErrorID).append("errorLevel", this.m_aErrorLevel).appendIfNotNull("errorFieldName", this.m_sErrorFieldName).append("errorText", this.m_sErrorText).toString();
    }

    @Nonnull
    public static SingleError createSuccess(@Nonnull @Nonempty String string) {
        return SingleError.createSuccess(null, null, string);
    }

    @Nonnull
    public static SingleError createSuccess(@Nullable String string, @Nonnull @Nonempty String string2) {
        return SingleError.createSuccess(null, string, string2);
    }

    @Nonnull
    public static SingleError createSuccess(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        return new SingleError(string, EErrorLevel.SUCCESS, string2, string3);
    }

    @Nonnull
    public static SingleError createInfo(@Nonnull @Nonempty String string) {
        return SingleError.createInfo(null, null, string);
    }

    @Nonnull
    public static SingleError createInfo(@Nullable String string, @Nonnull @Nonempty String string2) {
        return SingleError.createInfo(null, string, string2);
    }

    @Nonnull
    public static SingleError createInfo(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        return new SingleError(string, EErrorLevel.INFO, string2, string3);
    }

    @Nonnull
    public static SingleError createWarning(@Nonnull @Nonempty String string) {
        return SingleError.createWarning(null, null, string);
    }

    @Nonnull
    public static SingleError createWarning(@Nullable String string, @Nonnull @Nonempty String string2) {
        return SingleError.createWarning(null, string, string2);
    }

    @Nonnull
    public static SingleError createWarning(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        return new SingleError(string, EErrorLevel.WARN, string2, string3);
    }

    @Nonnull
    public static SingleError createError(@Nonnull @Nonempty String string) {
        return SingleError.createError(null, null, string);
    }

    @Nonnull
    public static SingleError createError(@Nullable String string, @Nonnull @Nonempty String string2) {
        return SingleError.createError(null, string, string2);
    }

    @Nonnull
    public static SingleError createError(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        return new SingleError(string, EErrorLevel.ERROR, string2, string3);
    }
}

