/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.random;

import com.helger.commons.ValueEnforcer;
import java.security.SecureRandom;
import java.security.Security;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class VerySecureRandom {
    public static final int DEFAULT_RE_SEED_INTERVAL = 20;
    private static final Logger s_aLogger = LoggerFactory.getLogger(VerySecureRandom.class);
    private static final int SEED_BYTE_COUNT = 16;
    private static final SecureRandom s_aSecureRandom;
    private static final VerySecureRandom s_aInstance;
    private static final AtomicInteger s_aReSeedInterval;
    private static final AtomicInteger s_aCounter;

    @Nonnull
    private static SecureRandom _createSecureRandomInstance() {
        SecureRandom secureRandom;
        block9: {
            try {
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Trying to get SecureRandom: IBMSecureRandom, IBMJCE");
                }
                secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Using SecureRandom: IBMSecureRandom, IBMJCE");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Trying to get SecureRandom: SHA1PRNG");
                    }
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Using SecureRandom: SHA1PRNG");
                    }
                }
                catch (Throwable throwable2) {
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Trying to get default SecureRandom");
                    }
                    secureRandom = new SecureRandom();
                    if (!s_aLogger.isDebugEnabled()) break block9;
                    s_aLogger.debug("Using default SecureRandom");
                }
            }
        }
        return secureRandom;
    }

    private VerySecureRandom() {
    }

    public static void setReSeedInterval(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ReseedInterval");
        s_aReSeedInterval.set(n);
    }

    @Nonnegative
    public static int getReSeedInterval() {
        return s_aReSeedInterval.get();
    }

    @Nonnull
    public static SecureRandom getInstance() {
        int n = VerySecureRandom.getReSeedInterval();
        if (n > 0 && s_aCounter.incrementAndGet() % n == 0) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Re-seeding VerySecureRandom");
            }
            s_aSecureRandom.setSeed(s_aSecureRandom.generateSeed(16));
        }
        return s_aSecureRandom;
    }

    static {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Strong SecureRandoms: " + Security.getProperty("securerandom.strongAlgorithms"));
        }
        SecureRandom secureRandom = VerySecureRandom._createSecureRandomInstance();
        secureRandom.setSeed(System.currentTimeMillis());
        secureRandom.nextBytes(new byte[128]);
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Generating intial seed for VerySecureRandom");
        }
        byte[] byArray = secureRandom.generateSeed(16);
        s_aSecureRandom = VerySecureRandom._createSecureRandomInstance();
        s_aSecureRandom.setSeed(byArray);
        s_aInstance = new VerySecureRandom();
        s_aReSeedInterval = new AtomicInteger(20);
        s_aCounter = new AtomicInteger(0);
    }
}

