/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonsHashMap<KEYTYPE, VALUETYPE>
extends HashMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    public CommonsHashMap() {
    }

    public CommonsHashMap(@Nonnegative int n) {
        super(n);
    }

    public CommonsHashMap(@Nonnegative int n, @Nonnegative float f) {
        super(n, f);
    }

    public CommonsHashMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(CollectionHelper.getSize(map));
        if (map != null) {
            this.putAll(map);
        }
    }

    public <COLLTYPE> CommonsHashMap(@Nullable Collection<? extends COLLTYPE> collection, @Nonnull Function<? super COLLTYPE, ? extends KEYTYPE> function, @Nonnull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(collection));
        this.putAll(collection, function, function2);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <K, V> CommonsHashMap<K, V> createInstance() {
        return new CommonsHashMap<KEYTYPE, VALUETYPE>();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CommonsHashMap<KEYTYPE, VALUETYPE> getClone() {
        return new CommonsHashMap<KEYTYPE, VALUETYPE>(this);
    }
}

