/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EErrorLevel implements IErrorLevel
{
    SUCCESS("success", 0),
    INFO("info", 100),
    WARN("warn", 200),
    ERROR("error", 300),
    FATAL_ERROR("fatal_error", 400);

    public static final EErrorLevel LOWEST;
    public static final EErrorLevel HIGHEST;
    private final String m_sID;
    private final int m_nNumericLevel;

    private EErrorLevel(String string2, int n2) {
        this.m_sID = string2;
        this.m_nNumericLevel = n2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    @Nullable
    public static EErrorLevel getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EErrorLevel.class, string);
    }

    @Nonnull
    public static EErrorLevel getFromIDOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDOrThrow(EErrorLevel.class, string);
    }

    @Nullable
    public static EErrorLevel getFromIDOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return EnumHelper.getFromIDOrDefault(EErrorLevel.class, string, eErrorLevel);
    }

    @Nullable
    public static EErrorLevel getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrNull(EErrorLevel.class, string);
    }

    @Nonnull
    public static EErrorLevel getFromIDCaseInsensitiveOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrThrow(EErrorLevel.class, string);
    }

    @Nullable
    public static EErrorLevel getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(EErrorLevel.class, string, eErrorLevel);
    }

    static {
        LOWEST = SUCCESS;
        HIGHEST = FATAL_ERROR;
    }
}

