/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.ISeverityComparable;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.IErrorIndicator;
import com.helger.commons.state.ISuccessIndicator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IErrorLevel
extends IHasID<String>,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<IErrorLevel>,
Serializable {
    @Nonnegative
    public int getNumericLevel();

    @Override
    default public boolean isSuccess() {
        return this.isEqualSevereThan(EErrorLevel.SUCCESS);
    }

    @Override
    default public boolean isFailure() {
        return this.isMoreSevereThan(EErrorLevel.SUCCESS);
    }

    @Override
    default public boolean isError() {
        return this.isMoreOrEqualSevereThan(EErrorLevel.ERROR);
    }

    @Override
    default public boolean isNoError() {
        return this.isLessSevereThan(EErrorLevel.ERROR);
    }

    @Override
    default public boolean isEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() == iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLessSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() < iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLessOrEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() <= iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isMoreSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() > iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isMoreOrEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() >= iErrorLevel.getNumericLevel();
    }

    default public boolean isHighest() {
        return this.isMoreOrEqualSevereThan(EErrorLevel.HIGHEST);
    }

    @Nullable
    public static IErrorLevel getMostSevere(@Nullable IErrorLevel iErrorLevel, @Nullable IErrorLevel iErrorLevel2) {
        if (EqualsHelper.identityEqual(iErrorLevel, iErrorLevel2)) {
            return iErrorLevel;
        }
        if (iErrorLevel == null) {
            return iErrorLevel2;
        }
        if (iErrorLevel2 == null) {
            return iErrorLevel;
        }
        return iErrorLevel.isMoreSevereThan(iErrorLevel2) ? iErrorLevel : iErrorLevel2;
    }
}

