/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsIterable;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasErrorLevels;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.errorlist.IErrorBase;
import com.helger.commons.lang.IHasSize;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface IResourceErrorGroup
extends IHasSize,
ICommonsIterable<IResourceError>,
IHasErrorLevels,
Serializable {
    @Override
    @Nonnull
    default public IErrorLevel getMostSevereErrorLevel() {
        IResourceError iResourceError;
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = EErrorLevel.SUCCESS;
        Iterator iterator = this.iterator();
        while (!(!iterator.hasNext() || (iErrorLevel = (iResourceError = (IResourceError)iterator.next()).getErrorLevel()).isMoreSevereThan(iErrorLevel2) && (iErrorLevel2 = iErrorLevel).isHighest())) {
        }
        return iErrorLevel2;
    }

    @Override
    default public boolean containsOnlySuccess() {
        return this.containsOnly(IErrorBase::isSuccess);
    }

    @Override
    default public boolean containsAtLeastOneSuccess() {
        return this.containsAny(IErrorBase::isSuccess);
    }

    @Override
    default public boolean containsNoSuccess() {
        return this.containsNone(IErrorBase::isSuccess);
    }

    @Override
    default public boolean containsOnlyFailure() {
        return this.containsOnly(IErrorBase::isFailure);
    }

    @Override
    default public boolean containsAtLeastOneFailure() {
        return this.containsAny(IErrorBase::isFailure);
    }

    @Override
    default public boolean containsNoFailure() {
        return this.containsNone(IErrorBase::isFailure);
    }

    @Override
    default public boolean containsOnlyError() {
        return this.containsOnly(IErrorBase::isError);
    }

    @Override
    default public boolean containsAtLeastOneError() {
        return this.containsAny(IErrorBase::isError);
    }

    @Override
    default public boolean containsNoError() {
        return this.containsNone(IErrorBase::isError);
    }

    @Nonnull
    default public IResourceErrorGroup getAllFailures() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        this.findAll(IErrorBase::isFailure, resourceErrorGroup::addResourceError);
        return resourceErrorGroup;
    }

    @Nonnull
    default public IResourceErrorGroup getAllErrors() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        this.findAll(IErrorBase::isError, resourceErrorGroup::addResourceError);
        return resourceErrorGroup;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IResourceError> getAllResourceErrors();

    @Deprecated
    default public void forEachResourceError(@Nonnull Consumer<? super IResourceError> consumer) {
        this.getAllResourceErrors().forEach(consumer);
    }
}

