/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.errorlist.ErrorList;
import com.helger.commons.errorlist.IError;
import com.helger.commons.errorlist.IErrorList;
import com.helger.commons.errorlist.IFieldErrorList;
import com.helger.commons.errorlist.SingleError;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FormErrors
implements Serializable,
IFieldErrorList {
    private final ErrorList m_aFormGlobalErrs = new ErrorList();
    private final ErrorList m_aFormFieldErrs = new ErrorList();

    public void addAll(@Nullable FormErrors formErrors) {
        if (formErrors != null) {
            for (IError iError : formErrors.m_aFormGlobalErrs) {
                this.addGlobalItem(iError);
            }
            for (IError iError : formErrors.m_aFormFieldErrs) {
                this.addFieldItem(iError);
            }
        }
    }

    public void addGlobalItem(@Nonnull IError iError) {
        ValueEnforcer.notNull(iError, "FormError");
        this.m_aFormGlobalErrs.add(iError);
    }

    public void addGlobalInfo(@Nonnull @Nonempty String string) {
        this.addGlobalItem(SingleError.createInfo(string));
    }

    public void addGlobalWarning(@Nonnull @Nonempty String string) {
        this.addGlobalItem(SingleError.createWarning(string));
    }

    public void addGlobalError(@Nonnull @Nonempty String string) {
        this.addGlobalItem(SingleError.createError(string));
    }

    public void addFieldItem(@Nonnull IError iError) {
        ValueEnforcer.notNull(iError, "FormFieldError");
        this.m_aFormFieldErrs.add(iError);
    }

    public void addFieldInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.addFieldItem(SingleError.createInfo(string, string2));
    }

    public void addFieldWarning(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.addFieldItem(SingleError.createWarning(string, string2));
    }

    public void addFieldError(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.addFieldItem(SingleError.createError(string, string2));
    }

    public void addFieldError(@Nonnull @Nonempty String[] stringArray, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmptyNoNullValue(stringArray, "FieldNames");
        for (String string2 : stringArray) {
            this.addFieldError(string2, string);
        }
    }

    public boolean isEmpty() {
        return this.m_aFormGlobalErrs.isEmpty() && this.m_aFormFieldErrs.isEmpty();
    }

    public boolean hasGlobalErrorsOrWarnings() {
        return this.m_aFormGlobalErrs.hasErrorsOrWarnings();
    }

    public boolean hasFormFieldErrorsOrWarnings() {
        return this.m_aFormFieldErrs.hasErrorsOrWarnings();
    }

    public boolean hasErrorsOrWarnings() {
        return this.m_aFormGlobalErrs.hasErrorsOrWarnings() || this.m_aFormFieldErrs.hasErrorsOrWarnings();
    }

    @Nonnegative
    public int getGlobalItemCount() {
        return this.m_aFormGlobalErrs.getItemCount();
    }

    @Nonnegative
    public int getFieldItemCount() {
        return this.m_aFormFieldErrs.getItemCount();
    }

    @Nonnegative
    public int getItemCount() {
        return this.m_aFormGlobalErrs.getItemCount() + this.m_aFormFieldErrs.getItemCount();
    }

    @Nonnull
    public IErrorLevel getMostSevereErrorLevel() {
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = this.m_aFormGlobalErrs.getMostSevereErrorLevel();
        return iErrorLevel2.isMoreSevereThan(iErrorLevel = this.m_aFormFieldErrs.getMostSevereErrorLevel()) ? iErrorLevel2 : iErrorLevel;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IError> getAllGlobalItems() {
        return this.m_aFormGlobalErrs.getAllItems();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllGlobalItemTexts() {
        return this.m_aFormGlobalErrs.getAllItemTexts();
    }

    @Override
    public boolean hasNoEntryForField(@Nullable String string) {
        return this.m_aFormFieldErrs.hasNoEntryForField(string);
    }

    @Override
    public boolean hasNoEntryForFields(String ... stringArray) {
        return this.m_aFormFieldErrs.hasNoEntryForFields(stringArray);
    }

    @Override
    public boolean hasEntryForField(@Nullable String string) {
        return this.m_aFormFieldErrs.hasEntryForField(string);
    }

    @Override
    public boolean hasEntryForFields(String ... stringArray) {
        return this.m_aFormFieldErrs.hasEntryForFields(stringArray);
    }

    @Override
    public boolean hasEntryForField(@Nullable String string, @Nullable IErrorLevel iErrorLevel) {
        return this.m_aFormFieldErrs.hasEntryForField(string, iErrorLevel);
    }

    public boolean hasErrorForField(@Nullable String string) {
        return this.hasEntryForField(string, EErrorLevel.ERROR);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getListOfField(@Nullable String string) {
        return this.m_aFormFieldErrs.getListOfField(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getListOfFields(String ... stringArray) {
        return this.m_aFormFieldErrs.getListOfFields(stringArray);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getListOfFieldsStartingWith(String ... stringArray) {
        return this.m_aFormFieldErrs.getListOfFieldsStartingWith(stringArray);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getListOfFieldsRegExp(@Nonnull @RegEx @Nonempty String string) {
        return this.m_aFormFieldErrs.getListOfFieldsRegExp(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfField(@Nullable String string) {
        return this.m_aFormFieldErrs.getAllItemTextsOfField(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFields(String ... stringArray) {
        return this.m_aFormFieldErrs.getAllItemTextsOfFields(stringArray);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFieldsStartingWith(String ... stringArray) {
        return this.m_aFormFieldErrs.getAllItemTextsOfFieldsStartingWith(stringArray);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFieldsRegExp(@Nonnull @RegEx @Nonempty String string) {
        return this.m_aFormFieldErrs.getAllItemTextsOfFieldsRegExp(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IError> getAllFieldItems() {
        return this.m_aFormFieldErrs.getAllItems();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllFieldItemTexts() {
        return this.m_aFormFieldErrs.getAllItemTexts();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, IError> getGroupedByFieldName() {
        return this.m_aFormFieldErrs.getGroupedByFieldName();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, IError> getGroupedByID() {
        return this.m_aFormFieldErrs.getGroupedByID();
    }

    @Nonnull
    public EChange clear() {
        return this.m_aFormGlobalErrs.clear().or(this.m_aFormFieldErrs.clear());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormErrors formErrors = (FormErrors)object;
        return this.m_aFormGlobalErrs.equals(formErrors.m_aFormGlobalErrs) && this.m_aFormFieldErrs.equals(formErrors.m_aFormFieldErrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Iterable)this.m_aFormGlobalErrs)).append((Iterable)this.m_aFormFieldErrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("formGlobalErrors", this.m_aFormGlobalErrs).append("formFieldErrors", this.m_aFormFieldErrs).toString();
    }
}

