/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.charset.CCharset;
import com.helger.commons.codec.AbstractRFC1522Codec;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RFC1522BCodec
extends AbstractRFC1522Codec {
    public RFC1522BCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public RFC1522BCodec(@Nonnull Charset charset) {
        super(charset);
    }

    @Override
    protected String getRFC1522Encoding() {
        return "B";
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    protected byte[] getEncoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeEncodeBytesToBytes(byArray, n, n2);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    protected byte[] getDecoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeDecode(byArray, n, n2);
    }
}

