/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.state.EContinue;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsIterable<ELEMENTTYPE>
extends Iterable<ELEMENTTYPE> {
    @Override
    default public void forEach(@Nonnull ObjIntConsumer<? super ELEMENTTYPE> objIntConsumer) {
        int n = 0;
        for (Object t : this) {
            objIntConsumer.accept(t, n);
            ++n;
        }
    }

    @Nonnull
    default public EContinue forEachBreakable(@Nonnull Function<? super ELEMENTTYPE, EContinue> function) {
        Objects.requireNonNull(function);
        for (Object t : this) {
            if (!function.apply(t).isBreak()) continue;
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        CollectionHelper.findAll(this, predicate, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, predicate, function, consumer);
    }

    default public <DSTTYPE extends ELEMENTTYPE> void findAllInstanceOf(@Nonnull Class<DSTTYPE> clazz, @Nonnull Consumer<? super DSTTYPE> consumer) {
        this.findAllMapped(object -> clazz.isInstance(object), object -> clazz.cast(object), consumer);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return this.findFirst(predicate, null);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.findFirst(this, predicate, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return this.findFirstMapped(predicate, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.findFirstMapped(this, predicate, function, DSTTYPE);
    }

    default public boolean containsAny(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsAny(this, predicate);
    }

    default public boolean containsNone(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsNone(this, predicate);
    }

    default public boolean containsOnly(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsOnly(this, predicate);
    }

    @Nonnegative
    default public int getIteratorCount() {
        return IteratorHelper.getSize(this.iterator());
    }

    @Nonnegative
    default public int getIteratorCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.getIteratorCount();
        }
        int n = 0;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            ++n;
        }
        return n;
    }
}

