/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.ext.CommonsCopyOnWriteArraySet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import com.helger.commons.state.EChange;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDeadlockDetector {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ThreadDeadlockDetector.class);
    private final ThreadMXBean m_aMBean = ManagementFactory.getThreadMXBean();
    private final ICommonsSet<IThreadDeadlockCallback> m_aCallbacks = new CommonsCopyOnWriteArraySet<IThreadDeadlockCallback>();

    public void findDeadlockedThreads() {
        long[] lArray;
        long[] lArray2 = lArray = this.m_aMBean.isSynchronizerUsageSupported() ? this.m_aMBean.findDeadlockedThreads() : this.m_aMBean.findMonitorDeadlockedThreads();
        if (ArrayHelper.isNotEmpty(lArray)) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Arrays.sort(lArray);
            ThreadDeadlockInfo[] threadDeadlockInfoArray = new ThreadDeadlockInfo[lArray.length];
            for (int i = 0; i < threadDeadlockInfoArray.length; ++i) {
                ThreadInfo object = this.m_aMBean.getThreadInfo(lArray[i]);
                Thread thread = null;
                StackTraceElement[] stackTraceElementArray = null;
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    if (entry.getKey().getId() != object.getThreadId()) continue;
                    thread = entry.getKey();
                    stackTraceElementArray = entry.getValue();
                    break;
                }
                if (thread == null) {
                    throw new IllegalStateException("Deadlocked Thread not found as defined by " + object.toString());
                }
                threadDeadlockInfoArray[i] = new ThreadDeadlockInfo(object, thread, stackTraceElementArray);
            }
            if (this.m_aCallbacks.isEmpty()) {
                s_aLogger.warn("Found a deadlock of " + threadDeadlockInfoArray.length + " threads but no callbacks are present!");
            } else {
                for (IThreadDeadlockCallback iThreadDeadlockCallback : this.m_aCallbacks) {
                    iThreadDeadlockCallback.onDeadlockDetected(threadDeadlockInfoArray);
                }
            }
        }
    }

    @Nonnull
    public EChange addCallback(@Nonnull IThreadDeadlockCallback iThreadDeadlockCallback) {
        ValueEnforcer.notNull(iThreadDeadlockCallback, "Callback");
        return this.m_aCallbacks.addObject(iThreadDeadlockCallback);
    }

    @Nonnull
    public EChange removeCallback(@Nullable IThreadDeadlockCallback iThreadDeadlockCallback) {
        return this.m_aCallbacks.removeObject(iThreadDeadlockCallback);
    }

    @Nonnull
    public EChange removeAllCallbacks() {
        return this.m_aCallbacks.removeAll();
    }

    @Nonnegative
    public int getCallbackCount() {
        return this.m_aCallbacks.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IThreadDeadlockCallback> getAllCallbacks() {
        return this.m_aCallbacks.getCopyAsList();
    }
}

