/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.debug;

import com.helger.commons.system.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalDebug {
    public static final boolean DEFAULT_DEBUG_MODE = true;
    public static final boolean DEFAULT_PRODUCTION_MODE = false;
    public static final String SYSTEM_PROPERTY_MAIL_DEBUG = "mail.debug";
    public static final String SYSTEM_PROPERTY_JAVAX_ACTIVATION_DEBUG = "javax.activation.debug";
    public static final String SYSTEM_PROPERTY_JAXP_DEBUG = "jaxp.debug";
    private static final AtomicBoolean s_aDebugMode = new AtomicBoolean(true);
    private static final AtomicBoolean s_aProductionMode = new AtomicBoolean(false);

    public void setDebugMode(boolean bl) {
        GlobalDebug.setDebugModeDirect(bl);
    }

    public void setProductionMode(boolean bl) {
        GlobalDebug.setProductionModeDirect(bl);
    }

    public static void setJavaCommonComponentsDebugMode(boolean bl) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAXP_DEBUG, bl);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAVAX_ACTIVATION_DEBUG, bl);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_MAIL_DEBUG, bl);
    }

    public static void setDebugModeDirect(boolean bl) {
        s_aDebugMode.set(bl);
        GlobalDebug.setJavaCommonComponentsDebugMode(bl);
    }

    public static void setProductionModeDirect(boolean bl) {
        s_aProductionMode.set(bl);
        if (bl) {
            GlobalDebug.setDebugModeDirect(false);
        }
    }

    public static boolean isDebugMode() {
        return s_aDebugMode.get();
    }

    public static boolean isProductionMode() {
        return s_aProductionMode.get();
    }
}

