/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.field.IHasErrorField;
import com.helger.commons.error.id.IHasErrorID;
import com.helger.commons.error.level.IHasErrorLevelComparable;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.error.text.IHasErrorText;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IError
extends IHasErrorLevelComparable<IError>,
IHasErrorID,
IHasErrorField {
    @Override
    default public String getErrorID() {
        return null;
    }

    @Override
    @Nullable
    default public String getErrorFieldName() {
        return null;
    }

    @Nonnull
    default public IErrorLocation getErrorLocation() {
        return ErrorLocation.NO_LOCATION;
    }

    default public boolean hasErrorLocation() {
        return this.getErrorLocation().isAnyInformationPresent();
    }

    @Nullable
    default public IHasErrorText getErrorTexts() {
        return null;
    }

    @Nullable
    default public String getErrorText(@Nonnull Locale locale) {
        IHasErrorText iHasErrorText = this.getErrorTexts();
        return iHasErrorText == null ? null : iHasErrorText.getDisplayText(locale);
    }

    @Nullable
    default public Throwable getLinkedException() {
        return null;
    }

    default public boolean hasLinkedException() {
        return this.getLinkedException() != null;
    }

    @Nullable
    default public String getLinkedExceptionMessage() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getMessage();
    }

    @Nullable
    default public StackTraceElement[] getLinkedExceptionStackTrace() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getStackTrace();
    }

    @Nullable
    default public Throwable getLinkedExceptionCause() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getCause();
    }

    @Nonnull
    @Nonempty
    default public String getAsString(@Nonnull Locale locale) {
        Throwable throwable;
        String string;
        IErrorLocation iErrorLocation;
        String string2;
        String string3 = "[" + (String)this.getErrorLevel().getID() + "]";
        String string4 = this.getErrorID();
        if (StringHelper.hasText(string4)) {
            string3 = string3 + "[" + string4 + "]";
        }
        if (StringHelper.hasText(string2 = this.getErrorFieldName())) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + "in " + string2;
        }
        if ((iErrorLocation = this.getErrorLocation()).isAnyInformationPresent()) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + "@ " + iErrorLocation.getAsString() + ":";
        }
        if (StringHelper.hasText(string = this.getErrorText(locale))) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + string;
        }
        if ((throwable = this.getLinkedException()) != null) {
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + "(" + throwable.getClass().getName() + ": " + throwable.getMessage() + ")";
        }
        return string3;
    }
}

