/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.text;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.text.IHasErrorText;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DynamicHasErrorText
implements IHasErrorText {
    private final IMultilingualText m_aText;

    public DynamicHasErrorText(@Nullable IMultilingualText iMultilingualText) {
        this.m_aText = ValueEnforcer.notNull(iMultilingualText, "Text");
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getText(locale);
    }

    @Override
    public boolean isMultiLingual() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DynamicHasErrorText dynamicHasErrorText = (DynamicHasErrorText)object;
        return EqualsHelper.equals(this.m_aText, dynamicHasErrorText.m_aText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("MLT", this.m_aText).toString();
    }
}

