/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.IErrorLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;

public interface IFieldErrorList<T extends IError> {
    public boolean hasNoEntryForField(@Nullable String var1);

    default public boolean hasNoEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasEntryForField(@Nullable String var1);

    public boolean hasEntryForField(@Nullable String var1, @Nullable IErrorLevel var2);

    default public boolean hasEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IFieldErrorList<T> getListOfField(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public IFieldErrorList<T> getListOfFields(String ... var1);

    @Nonnull
    @ReturnsMutableCopy
    public IFieldErrorList<T> getListOfFieldsStartingWith(String ... var1);

    @Nonnull
    @ReturnsMutableCopy
    public IFieldErrorList<T> getListOfFieldsRegExp(@Nonnull @RegEx @Nonempty String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfField(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFields(String ... var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFieldsStartingWith(String ... var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllItemTextsOfFieldsRegExp(@Nonnull @RegEx @Nonempty String var1);

    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, T> getGroupedByID();

    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, T> getGroupedByFieldName();
}

