/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.format.AbstractFormatterString;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormatterStringPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringPrefixAndSuffix(@Nonnull String string, @Nonnull String string2) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
        this.m_sSuffix = ValueEnforcer.notNull(string2, "Suffix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        return this.m_sPrefix + this.getValueAsString(object) + this.m_sSuffix;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringPrefixAndSuffix formatterStringPrefixAndSuffix = (FormatterStringPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", this.m_sPrefix).append("suffix", this.m_sSuffix).toString();
    }
}

