/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TextHelper {
    public static final Locale DE = LocaleCache.getInstance().getLocale("de");
    public static final Locale EN = LocaleCache.getInstance().getLocale("en");
    private static final TextHelper s_aInstance = new TextHelper();

    private TextHelper() {
    }

    @Nullable
    public static String getFormattedText(@Nullable String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (ArrayHelper.isEmpty(objectArray)) {
            return string;
        }
        MessageFormat messageFormat = new MessageFormat(string, Locale.getDefault(Locale.Category.FORMAT));
        return messageFormat.format(objectArray);
    }

    @Nullable
    public static String getFormattedText(@Nonnull Locale locale, @Nullable String string, Object ... objectArray) {
        ValueEnforcer.notNull(locale, "DisplayLocale");
        if (string == null) {
            return null;
        }
        if (ArrayHelper.isEmpty(objectArray)) {
            return string;
        }
        MessageFormat messageFormat = new MessageFormat(string, locale);
        return messageFormat.format(objectArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_DE(@Nonnull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_EN(@Nonnull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(EN, string);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_DE_EN(@Nonnull String string, @Nonnull String string2) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        multilingualText.addText(EN, string2);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText getCopyWithLocales(@Nonnull IMultilingualText iMultilingualText, @Nonnull Collection<Locale> collection) {
        MultilingualText multilingualText = new MultilingualText();
        for (Locale locale : collection) {
            if (!iMultilingualText.containsLocale(locale)) continue;
            multilingualText.setText(locale, iMultilingualText.getText(locale));
        }
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText createMultilingualTextFromMap(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, "Map");
        MultilingualText multilingualText = new MultilingualText();
        LocaleCache localeCache = LocaleCache.getInstance();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            multilingualText.setText(localeCache.getLocale(entry.getKey()), string);
        }
        return multilingualText;
    }
}

