/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AnnotationUsageCache
implements Serializable {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final Class<? extends Annotation> m_aAnnotationClass;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ETriState> m_aMap = new CommonsHashMap<String, ETriState>();

    public AnnotationUsageCache(@Nonnull Class<? extends Annotation> clazz) {
        RetentionPolicy retentionPolicy;
        ValueEnforcer.notNull(clazz, "AnnotationClass");
        Retention retention = clazz.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy2 = retentionPolicy = retention == null ? RetentionPolicy.CLASS : retention.value();
        if (retentionPolicy != RetentionPolicy.RUNTIME) {
            throw new IllegalArgumentException("RetentionPolicy must be of type RUNTIME to be used within this cache. The current value ist " + (Object)((Object)retentionPolicy));
        }
        this.m_aAnnotationClass = clazz;
    }

    @Nonnull
    public final Class<? extends Annotation> getAnnotationClass() {
        return this.m_aAnnotationClass;
    }

    public boolean hasAnnotation(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        return this.hasAnnotation(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnnotation(@Nonnull Class<?> clazz) {
        ETriState eTriState;
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        this.m_aRWLock.readLock().lock();
        try {
            eTriState = (ETriState)this.m_aMap.get(string);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (eTriState == null) {
            eTriState = this.m_aRWLock.writeLocked(() -> this.m_aMap.computeIfAbsent(string, string -> ETriState.valueOf(clazz.getAnnotation(this.m_aAnnotationClass) != null)));
        }
        return eTriState.isTrue();
    }

    public void setAnnotation(@Nonnull Class<?> clazz, boolean bl) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        this.m_aRWLock.writeLocked(() -> this.m_aMap.put(string, ETriState.valueOf(bl)));
    }

    public void clearCache() {
        this.m_aRWLock.writeLocked(() -> this.m_aMap.clear());
    }

    public String toString() {
        return new ToStringGenerator(this).append("annotationClass", this.m_aAnnotationClass).append("map", this.m_aMap).toString();
    }
}

