/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.impl.MapEntry;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleElementMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    private boolean m_bHasElement = false;
    private KEYTYPE m_aKey;
    private VALUETYPE m_aValue;

    public SingleElementMap() {
    }

    public SingleElementMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.put(KEYTYPE, VALUETYPE);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SingleElementMap<KEYTYPE, VALUETYPE> getClone() {
        return this.m_bHasElement ? new SingleElementMap<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue) : new SingleElementMap<KEYTYPE, VALUETYPE>();
    }

    @Override
    public void clear() {
        this.m_bHasElement = false;
        this.m_aKey = null;
        this.m_aValue = null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.m_bHasElement && EqualsHelper.equals(this.m_aKey, object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.m_bHasElement && EqualsHelper.equals(this.m_aValue, object);
    }

    @Override
    @Nullable
    public VALUETYPE get(@Nullable Object object) {
        return this.containsKey(object) ? (VALUETYPE)this.m_aValue : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nullable
    public final VALUETYPE put(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        VALUETYPE VALUETYPE2 = null;
        if (EqualsHelper.equals(KEYTYPE, this.m_aKey)) {
            VALUETYPE2 = this.m_aValue;
        } else {
            this.m_aKey = KEYTYPE;
        }
        this.m_aValue = VALUETYPE;
        this.m_bHasElement = true;
        return VALUETYPE2;
    }

    @Override
    public void putAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null && !map.isEmpty()) {
            if (map.size() != 1) {
                throw new IllegalArgumentException("Only maps with exactly one element are allowed!");
            }
            Map.Entry<KEYTYPE, VALUETYPE> entry = map.entrySet().iterator().next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public VALUETYPE remove(@Nullable Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        VALUETYPE VALUETYPE = this.m_aValue;
        this.m_bHasElement = false;
        this.m_aValue = null;
        this.m_aKey = null;
        return VALUETYPE;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public Set<KEYTYPE> keySet() {
        return this.m_bHasElement ? new CommonsHashSet<KEYTYPE>(this.m_aKey) : new CommonsHashSet();
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public Collection<VALUETYPE> values() {
        return this.m_bHasElement ? new CommonsArrayList<VALUETYPE>(this.m_aValue) : new CommonsArrayList();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    @CodingStyleguideUnaware
    public Set<Map.Entry<KEYTYPE, VALUETYPE>> entrySet() {
        CommonsHashSet<int> commonsHashSet = new CommonsHashSet<int>(this.size());
        if (this.m_bHasElement) {
            commonsHashSet.add(new MapEntry<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue));
        }
        return commonsHashSet;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementMap singleElementMap = (SingleElementMap)object;
        return this.m_bHasElement == singleElementMap.m_bHasElement && EqualsHelper.equals(this.m_aKey, singleElementMap.m_aKey) && EqualsHelper.equals(this.m_aValue, singleElementMap.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasElement).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasElement", this.m_bHasElement).append("key", this.m_aKey).append("value", this.m_aValue).toString();
    }
}

