/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorFloat {
    private final float[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorFloat(float ... fArray) {
        this(fArray, 0, fArray.length);
    }

    public ArrayIteratorFloat(@Nonnull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(fArray, n, n2);
        this.m_aArray = ArrayHelper.getCopy(fArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public float next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorFloat arrayIteratorFloat = (ArrayIteratorFloat)object;
        return EqualsHelper.equals(this.m_aArray, arrayIteratorFloat.m_aArray) && this.m_nIndex == arrayIteratorFloat.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static ArrayIteratorFloat createOfsLen(@Nonnull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorFloat(fArray, n, n2);
    }

    @Nonnull
    public static ArrayIteratorFloat createBeginEnd(@Nonnull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorFloat.createOfsLen(fArray, n, n2 - n);
    }
}

