/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collation.CollatorHelper;
import com.helger.commons.compare.CompareHelper;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@FunctionalInterface
@NotThreadSafe
public interface IComparator<DATATYPE>
extends Comparator<DATATYPE>,
Serializable {
    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nullable Locale locale) {
        return IComparator.getComparatorCollating(CollatorHelper.getCollatorSpaceBeforeDot(locale));
    }

    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nonnull Collator collator) {
        ValueEnforcer.notNull(collator, "Collator");
        return Comparator.nullsFirst((string, string2) -> collator.compare((String)string, (String)string2));
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nullable Locale locale) {
        return Comparator.comparing(function, IComparator.getComparatorCollating(locale));
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nonnull Collator collator) {
        return Comparator.comparing(function, IComparator.getComparatorCollating(collator));
    }

    @Nonnull
    public static Comparator<String> getComparatorStringLongestFirst() {
        return Comparator.comparingInt(String::length).reversed().thenComparing(Function.identity());
    }

    @Nonnull
    public static Comparator<String> getComparatorStringShortestFirst() {
        return Comparator.comparingInt(String::length).thenComparing(Function.identity());
    }

    @Nonnull
    public static IComparator<String> getComparatorStringIgnoreCase() {
        return (string, string2) -> CompareHelper.compareIgnoreCase(string, string2);
    }
}

