/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.ResourceError;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@Deprecated
@NotThreadSafe
public class ResourceErrorGroup
implements IResourceErrorGroup,
ICloneable<ResourceErrorGroup>,
IClearable {
    private final ICommonsList<IResourceError> m_aErrors = new CommonsArrayList<IResourceError>();

    public ResourceErrorGroup() {
    }

    public ResourceErrorGroup(@Nonnull IResourceError iResourceError) {
        this.addResourceError(iResourceError);
    }

    public ResourceErrorGroup(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
    }

    public ResourceErrorGroup(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
    }

    @Nonnull
    public final ResourceErrorGroup addResourceError(@Nonnull IResourceError iResourceError) {
        ValueEnforcer.notNull(iResourceError, "ResourceError");
        this.m_aErrors.add(iResourceError);
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public final ResourceErrorGroup addResourceErrorGroup(@Nonnull IResourceErrorGroup iResourceErrorGroup) {
        ValueEnforcer.notNull(iResourceErrorGroup, "ResourceErrorGroup");
        this.m_aErrors.addAll(iResourceErrorGroup.getAllResourceErrors());
        return this;
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aErrors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getClone() {
        return new ResourceErrorGroup(this.m_aErrors);
    }

    @Override
    @Nonnull
    public Iterator<IResourceError> iterator() {
        return this.m_aErrors.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IResourceError> getAllResourceErrors() {
        return (ICommonsList)this.m_aErrors.getClone();
    }

    @Override
    @Nonnull
    public EChange clear() {
        return this.m_aErrors.removeAll();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceErrorGroup resourceErrorGroup = (ResourceErrorGroup)object;
        return this.m_aErrors.equals(resourceErrorGroup.m_aErrors);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aErrors)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("errors", this.m_aErrors).toString();
    }

    public static ResourceErrorGroup createAndConvert(@Nonnull IErrorList iErrorList) {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        if (iErrorList != null) {
            for (IError iError : iErrorList) {
                resourceErrorGroup.addResourceError(ResourceError.createAndConvert(iError));
            }
        }
        return resourceErrorGroup;
    }
}

