/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.level;

import com.helger.commons.collection.ext.ICommonsIterable;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.level.IHasErrorLevel;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IHasErrorLevels<IMPLTYPE extends IHasErrorLevel>
extends ICommonsIterable<IMPLTYPE> {
    default public boolean containsOnlySuccess() {
        return this.containsOnly(iHasErrorLevel -> iHasErrorLevel.isSuccess());
    }

    default public boolean containsAtLeastOneSuccess() {
        return this.containsAny(iHasErrorLevel -> iHasErrorLevel.isSuccess());
    }

    default public boolean containsNoSuccess() {
        return this.containsNone(iHasErrorLevel -> iHasErrorLevel.isSuccess());
    }

    @Nonnegative
    default public int getSuccessCount() {
        return this.getIteratorCount(iHasErrorLevel -> iHasErrorLevel.isSuccess());
    }

    default public boolean containsOnlyFailure() {
        return this.containsOnly(iHasErrorLevel -> iHasErrorLevel.isFailure());
    }

    default public boolean containsAtLeastOneFailure() {
        return this.containsAny(iHasErrorLevel -> iHasErrorLevel.isFailure());
    }

    default public boolean containsNoFailure() {
        return this.containsNone(iHasErrorLevel -> iHasErrorLevel.isFailure());
    }

    @Nonnegative
    default public int getFailureCount() {
        return this.getIteratorCount(iHasErrorLevel -> iHasErrorLevel.isFailure());
    }

    default public boolean containsOnlyError() {
        return this.containsOnly(iHasErrorLevel -> iHasErrorLevel.isError());
    }

    default public boolean containsAtLeastOneError() {
        return this.containsAny(iHasErrorLevel -> iHasErrorLevel.isError());
    }

    default public boolean containsNoError() {
        return this.containsNone(iHasErrorLevel -> iHasErrorLevel.isError());
    }

    @Nonnegative
    default public int getErrorCount() {
        return this.getIteratorCount(iHasErrorLevel -> iHasErrorLevel.isError());
    }

    @Deprecated
    default public boolean hasErrorsOrWarnings() {
        return this.containsAtLeastOneWarningOrError();
    }

    default public boolean containsAtLeastOneWarningOrError() {
        return this.containsAny(iHasErrorLevel -> iHasErrorLevel.getErrorLevel().isMoreOrEqualSevereThan(EErrorLevel.WARN));
    }

    @Nonnull
    default public IErrorLevel getMostSevereErrorLevel() {
        IHasErrorLevel iHasErrorLevel;
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = EErrorLevel.LOWEST;
        Iterator iterator = this.iterator();
        while (!(!iterator.hasNext() || (iErrorLevel = (iHasErrorLevel = (IHasErrorLevel)iterator.next()).getErrorLevel()).isMoreSevereThan(iErrorLevel2) && (iErrorLevel2 = iErrorLevel).isHighest())) {
        }
        return iErrorLevel2;
    }
}

