/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.monitor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.monitor.FileChangeEvent;
import com.helger.commons.io.monitor.FileMonitorAgent;
import com.helger.commons.io.monitor.IFileMonitorCallback;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.Stack;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileMonitor.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final IFileMonitorCallback m_aListener;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, FileMonitorAgent> m_aMonitorMap = new CommonsHashMap<String, FileMonitorAgent>();
    private final Stack<File> m_aDeleteStack = new Stack();
    private final Stack<File> m_aAddStack = new Stack();
    private boolean m_bRecursive;

    public FileMonitor(@Nonnull IFileMonitorCallback iFileMonitorCallback) {
        this.m_aListener = ValueEnforcer.notNull(iFileMonitorCallback, "Listener");
    }

    @Nonnull
    public IFileMonitorCallback getListener() {
        return this.m_aListener;
    }

    public boolean isRecursive() {
        return this.m_bRecursive;
    }

    @Nonnull
    public FileMonitor setRecursive(boolean bl) {
        this.m_bRecursive = bl;
        return this;
    }

    @Nonnull
    private EChange _recursiveAddFile(@Nonnull File file, boolean bl) {
        File[] fileArray;
        String string = file.getAbsolutePath();
        if (this.m_aRWLock.readLocked(() -> this.m_aMonitorMap.containsKey(string))) {
            return EChange.UNCHANGED;
        }
        EChange eChange = this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMonitorMap.containsKey(string)) {
                return EChange.UNCHANGED;
            }
            this.m_aMonitorMap.put(string, new FileMonitorAgent(this, file));
            return EChange.CHANGED;
        });
        if (eChange.isChanged() && bl && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                this._recursiveAddFile(file2, true);
            }
        }
        return eChange;
    }

    @Nonnegative
    protected int getMonitoredFileCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aMonitorMap.size());
    }

    @Nonnull
    public EChange addMonitoredFile(@Nonnull File file) {
        if (this._recursiveAddFile(file, false).isUnchanged()) {
            return EChange.UNCHANGED;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this._recursiveAddFile(file2, this.m_bRecursive);
            }
        }
        s_aLogger.info("Added " + (this.m_bRecursive ? "recursive " : "") + "monitoring for file changes in " + file.getAbsolutePath() + " - monitoring " + this.getMonitoredFileCount() + " files and directories in total");
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeMonitoredFile(@Nonnull File file) {
        String string;
        FileMonitorAgent fileMonitorAgent;
        ValueEnforcer.notNull(file, "File");
        String string2 = file.getAbsolutePath();
        if (this.m_aRWLock.writeLocked(() -> this.m_aMonitorMap.remove(string2) == null)) {
            return EChange.UNCHANGED;
        }
        File file2 = file.getParentFile();
        if (file2 != null && (fileMonitorAgent = this.m_aRWLock.readLocked(() -> this.lambda$removeMonitoredFile$4(string = file2.getAbsolutePath()))) != null) {
            fileMonitorAgent.resetChildrenList();
        }
        s_aLogger.info("Removed " + (this.m_bRecursive ? "recursive " : "") + "monitoring for file changes in " + file.getAbsolutePath() + " - monitoring " + this.getMonitoredFileCount() + " files and directories in total");
        return EChange.CHANGED;
    }

    protected void onFileCreated(@Nonnull File file) {
        try {
            this.m_aListener.onFileCreated(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileCreated listener " + this.m_aListener + " on file " + file, throwable);
        }
        this.m_aAddStack.push(file);
    }

    protected void onFileDeleted(@Nonnull File file) {
        try {
            this.m_aListener.onFileDeleted(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileDeleted listener " + this.m_aListener + " for file " + file, throwable);
        }
        this.m_aDeleteStack.push(file);
    }

    protected void onFileChanged(@Nonnull File file) {
        try {
            this.m_aListener.onFileChanged(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileChanged listener " + this.m_aListener + " for file " + file, throwable);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    protected ICommonsCollection<FileMonitorAgent> getAllAgents() {
        return this.m_aRWLock.readLocked(() -> this.m_aMonitorMap.copyOfValues());
    }

    protected void applyPendingDeletes() {
        while (!this.m_aDeleteStack.isEmpty()) {
            this.removeMonitoredFile(this.m_aDeleteStack.pop());
        }
    }

    protected void applyPendingAdds() {
        while (!this.m_aAddStack.isEmpty()) {
            this.addMonitoredFile(this.m_aAddStack.pop());
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("listener", this.m_aListener).append("recursive", this.m_bRecursive).toString();
    }

    private /* synthetic */ FileMonitorAgent lambda$removeMonitoredFile$4(String string) {
        return (FileMonitorAgent)this.m_aMonitorMap.get(string);
    }
}

