/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.charset.CCharset;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class NonBlockingProperties
extends CommonsLinkedHashMap<String, String> {
    protected NonBlockingProperties m_aDefaults;

    public NonBlockingProperties() {
        this((NonBlockingProperties)null);
    }

    public NonBlockingProperties(@Nullable NonBlockingProperties nonBlockingProperties) {
        this.m_aDefaults = nonBlockingProperties;
    }

    @Nullable
    public NonBlockingProperties getDefaults() {
        return this.m_aDefaults;
    }

    @Nullable
    public String setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public void load(@WillNotClose Reader reader) throws IOException {
        this._load(new LineReader(reader));
    }

    public void load(@WillNotClose InputStream inputStream) throws IOException {
        this._load(new LineReader(inputStream));
    }

    private void _load(@WillNotClose LineReader lineReader) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while ((n = lineReader.readLine()) >= 0) {
            int n2;
            char c = '\u0000';
            int n3 = n;
            boolean bl = false;
            boolean bl2 = false;
            for (n2 = 0; n2 < n; ++n2) {
                c = lineReader.m_aLineBuf[n2];
                if (!(c != '=' && c != ':' || bl2)) {
                    n3 = n2 + 1;
                    bl = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || bl2)) {
                    n3 = n2 + 1;
                    break;
                }
                bl2 = c == '\\' ? !bl2 : false;
            }
            while (n3 < n) {
                c = lineReader.m_aLineBuf[n3];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (bl || c != '=' && c != ':') break;
                    bl = true;
                }
                ++n3;
            }
            String string = this._loadConvert(lineReader.m_aLineBuf, 0, n2, cArray);
            String string2 = this._loadConvert(lineReader.m_aLineBuf, n3, n - n3, cArray);
            this.put(string, string2);
        }
    }

    @Nonnull
    private String _loadConvert(char[] cArray, int n, int n2, @Nonnull char[] cArray2) {
        char[] cArray3;
        int n3;
        int n4 = n;
        if (cArray2.length < n2) {
            n3 = n2 * 2;
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            cArray3 = new char[n3];
        } else {
            cArray3 = cArray2;
        }
        int n5 = 0;
        int n6 = n4 + n2;
        while (n4 < n6) {
            if ((n3 = cArray[n4++]) == 92) {
                if ((n3 = cArray[n4++]) == 117) {
                    int n7 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = cArray[n4++];
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n7 = (n7 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n7 = (n7 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n7 = (n7 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    cArray3[n5++] = (char)n7;
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                cArray3[n5++] = n3;
                continue;
            }
            cArray3[n5++] = n3;
        }
        return new String(cArray3, 0, n5);
    }

    @Nonnull
    private String _saveConvert(String string, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    stringBuilder.append('\\').append('\\');
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    stringBuilder.append('\\').append(c);
                    continue block8;
                }
                default: {
                    if ((c < ' ' || c > '~') && bl2) {
                        stringBuilder.append('\\').append('u').append(StringHelper.getHexChar(c >> 12 & 0xF)).append(StringHelper.getHexChar(c >> 8 & 0xF)).append(StringHelper.getHexChar(c >> 4 & 0xF)).append(StringHelper.getHexChar(c & 0xF));
                        continue block8;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void _writeComments(@Nonnull @WillNotClose Writer writer, @Nonnull String string) throws IOException {
        int n;
        writer.write("#");
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[1] = 117;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (n3 != n) {
                writer.write(string.substring(n3, n));
            }
            if (c > '\u00ff') {
                cArray[2] = StringHelper.getHexChar(c >> 12 & 0xF);
                cArray[3] = StringHelper.getHexChar(c >> 8 & 0xF);
                cArray[4] = StringHelper.getHexChar(c >> 4 & 0xF);
                cArray[5] = StringHelper.getHexChar(c & 0xF);
                writer.write(cArray);
            } else {
                writer.write(ENewLineMode.DEFAULT.getText());
                if (c == '\r' && n != n2 - 1 && string.charAt(n + 1) == '\n') {
                    ++n;
                }
                if (n == n2 - 1 || string.charAt(n + 1) != '#' && string.charAt(n + 1) != '!') {
                    writer.write("#");
                }
            }
            n3 = n + 1;
        }
        if (n3 != n) {
            writer.write(string.substring(n3, n));
        }
        writer.write(ENewLineMode.DEFAULT.getText());
    }

    public void store(@Nonnull @WillNotClose Writer writer, @Nullable String string) throws IOException {
        this._store(StreamHelper.getBuffered(writer), string, false);
    }

    public void store(@Nonnull @WillNotClose OutputStream outputStream, @Nullable String string) throws IOException {
        this._store(new NonBlockingBufferedWriter(new OutputStreamWriter(outputStream, CCharset.CHARSET_ISO_8859_1_OBJ)), string, true);
    }

    private void _store(@Nonnull @WillNotClose Writer writer, @Nullable String string, boolean bl) throws IOException {
        if (string != null) {
            NonBlockingProperties._writeComments(writer, string);
        }
        String string2 = ENewLineMode.DEFAULT.getText();
        writer.write("#" + ZonedDateTime.now().toString() + string2);
        for (Map.Entry entry : this.entrySet()) {
            String string3 = (String)entry.getKey();
            string3 = this._saveConvert(string3, true, bl);
            String string4 = (String)entry.getValue();
            string4 = this._saveConvert(string4, false, bl);
            writer.write(string3);
            writer.write(61);
            writer.write(string4);
            writer.write(string2);
        }
        writer.flush();
    }

    @Nullable
    public String getProperty(@Nullable String string) {
        String string2 = (String)super.get(string);
        return string2 == null && this.m_aDefaults != null ? this.m_aDefaults.getProperty(string) : string2;
    }

    @Nullable
    public String getProperty(@Nullable String string, @Nullable String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    @Nonnull
    public static NonBlockingProperties create(@Nullable Map<Object, Object> map) {
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                nonBlockingProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return nonBlockingProperties;
    }

    static class LineReader {
        private byte[] m_aInByteBuf;
        private char[] m_aInCharBuf;
        private char[] m_aLineBuf = new char[1024];
        private int m_nInLimit = 0;
        private int m_nInOff = 0;
        private InputStream m_aIS;
        private Reader m_aReader;

        public LineReader(InputStream inputStream) {
            this.m_aIS = inputStream;
            this.m_aInByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.m_aReader = reader;
            this.m_aInCharBuf = new char[8192];
        }

        protected int readLine() throws IOException {
            int n = 0;
            char c = '\u0000';
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            while (true) {
                if (this.m_nInOff >= this.m_nInLimit) {
                    this.m_nInLimit = this.m_aIS == null ? this.m_aReader.read(this.m_aInCharBuf) : this.m_aIS.read(this.m_aInByteBuf);
                    this.m_nInOff = 0;
                    if (this.m_nInLimit <= 0) {
                        if (n == 0 || bl2) {
                            return -1;
                        }
                        return n;
                    }
                }
                c = this.m_aIS != null ? (char)(0xFF & this.m_aInByteBuf[this.m_nInOff++]) : this.m_aInCharBuf[this.m_nInOff++];
                if (bl6) {
                    bl6 = false;
                    if (c == '\n') continue;
                }
                if (bl) {
                    if (c == ' ' || c == '\t' || c == '\f' || !bl4 && (c == '\r' || c == '\n')) continue;
                    bl = false;
                    bl4 = false;
                }
                if (bl3) {
                    bl3 = false;
                    if (c == '#' || c == '!') {
                        bl2 = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.m_aLineBuf[n++] = c;
                    if (n == this.m_aLineBuf.length) {
                        int n2 = this.m_aLineBuf.length * 2;
                        if (n2 < 0) {
                            n2 = Integer.MAX_VALUE;
                        }
                        char[] cArray = new char[n2];
                        System.arraycopy(this.m_aLineBuf, 0, cArray, 0, this.m_aLineBuf.length);
                        this.m_aLineBuf = cArray;
                    }
                    if (c == '\\') {
                        bl5 = !bl5;
                        continue;
                    }
                    bl5 = false;
                    continue;
                }
                if (bl2 || n == 0) {
                    bl2 = false;
                    bl3 = true;
                    bl = true;
                    n = 0;
                    continue;
                }
                if (this.m_nInOff >= this.m_nInLimit) {
                    this.m_nInLimit = this.m_aIS == null ? this.m_aReader.read(this.m_aInCharBuf) : this.m_aIS.read(this.m_aInByteBuf);
                    this.m_nInOff = 0;
                    if (this.m_nInLimit <= 0) {
                        return n;
                    }
                }
                if (!bl5) break;
                --n;
                bl = true;
                bl4 = true;
                bl5 = false;
                if (c != '\r') continue;
                bl6 = true;
            }
            return n;
        }
    }
}

