/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.level.IHasErrorLevelComparable;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LogMessage
implements IHasErrorLevelComparable<LogMessage> {
    private final LocalDateTime m_aIssueDT;
    private final IErrorLevel m_aErrorLevel;
    private final Serializable m_aMsg;
    private final Throwable m_aThrowable;

    public LogMessage(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this(PDTFactory.getCurrentLocalDateTime(), iErrorLevel, serializable, throwable);
    }

    public LogMessage(@Nonnull LocalDateTime localDateTime, @Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.m_aIssueDT = ValueEnforcer.notNull(localDateTime, "IssueDT");
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_aMsg = ValueEnforcer.notNull(serializable, "Message");
        this.m_aThrowable = throwable;
    }

    @Nonnull
    public LocalDateTime getIssueDateTime() {
        return this.m_aIssueDT;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public Serializable getMessage() {
        return this.m_aMsg;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    public String toString() {
        return new ToStringGenerator(this).append("issueDT", this.m_aIssueDT).append("errorLevel", this.m_aErrorLevel).append("msg", this.m_aMsg).appendIfNotNull("throwable", this.m_aThrowable).toString();
    }
}

