/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resourcebundle;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.text.resourcebundle.XMLResourceBundleControl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XMLResourceBundle
extends ResourceBundle {
    private final ICommonsMap<String, String> m_aValues = new CommonsHashMap<String, String>();

    @DevelopersNote(value="Don't use it manually - use the static methods of this class!")
    XMLResourceBundle(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        Properties properties = new Properties();
        properties.loadFromXML(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.m_aValues.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllValues() {
        return (ICommonsMap)this.m_aValues.getClone();
    }

    @Override
    @CodingStyleguideUnaware
    protected Set<String> handleKeySet() {
        return this.m_aValues.keySet();
    }

    @Override
    protected String handleGetObject(@Nullable String string) {
        return (String)this.m_aValues.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return IteratorHelper.getEnumeration(this.m_aValues.keySet());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, Locale.getDefault(), new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, classLoader, new XMLResourceBundleControl());
    }
}

